package cn.com.duiba.goods.open.api.dto;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 订单确认请求参数
 * Created by guoyanfei .
 * 2022/12/19 .
 */
public class OrderConfirmDTO implements Serializable {

    private static final long serialVersionUID = 1429234962818008327L;

    /**
     * 订单号
     */
    @NotNull(message = "【订单号】不能为空")
    private String orderNo;

    /**
     * 备注
     */
    private String remark;

    public OrderConfirmDTO() {
    }

    public OrderConfirmDTO(String orderNo) {
        this.orderNo = orderNo;
    }

    public OrderConfirmDTO(String orderNo, String remark) {
        this.orderNo = orderNo;
        this.remark = remark;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}
