package cn.com.duiba.goods.open.api.dto;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 售后订单取消请求参数
 * Created by guoyanfei .
 * 2022/12/19 .
 */
public class RefundOrderCancelDTO implements Serializable {

    private static final long serialVersionUID = -4754797589620202594L;

    /**
     * 售后订单号
     */
    @NotBlank(message = "【售后订单号】不能为空")
    private String refundOrderNo;

    public RefundOrderCancelDTO() {
    }

    public RefundOrderCancelDTO(String refundOrderNo) {
        this.refundOrderNo = refundOrderNo;
    }

    public String getRefundOrderNo() {
        return refundOrderNo;
    }

    public void setRefundOrderNo(String refundOrderNo) {
        this.refundOrderNo = refundOrderNo;
    }

}
