package cn.com.duiba.goods.open.api.dto;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 发起售后请求参数
 * Created by guoyanfei .
 * 2022/12/13 .
 */
public class RefundOrderCreateDTO implements Serializable {

    private static final long serialVersionUID = -915548768537508583L;

    /**
     * 订单号
     */
    @NotBlank(message = "【订单号】不能为空")
    private String orderNo;

    /**
     * 售后类型
     * {@code @cn.com.duiba.goods.common.enums.order.RefundType}
     */
    @NotNull(message = "【售后类型】不能为空")
    private Integer refundType;

    /**
     * 售后原因
     */
    private String refundReason;

    /**
     * 买家补充描述
     */
    private String buyerRemark;

    /**
     * 买家手机号
     */
    private String buyerTel;

    /**
     * 售后图片
     */
    private String refundImgs;

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public Integer getRefundType() {
        return refundType;
    }

    public void setRefundType(Integer refundType) {
        this.refundType = refundType;
    }

    public String getRefundReason() {
        return refundReason;
    }

    public void setRefundReason(String refundReason) {
        this.refundReason = refundReason;
    }

    public String getBuyerRemark() {
        return buyerRemark;
    }

    public void setBuyerRemark(String buyerRemark) {
        this.buyerRemark = buyerRemark;
    }

    public String getBuyerTel() {
        return buyerTel;
    }

    public void setBuyerTel(String buyerTel) {
        this.buyerTel = buyerTel;
    }

    public String getRefundImgs() {
        return refundImgs;
    }

    public void setRefundImgs(String refundImgs) {
        this.refundImgs = refundImgs;
    }
}
