package cn.com.duiba.goods.open.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.open.api.dto.GoodsOpenDTO;
import cn.com.duiba.goods.open.api.dto.GoodsOpenQueryRequest;
import cn.com.duiba.wolf.entity.PageResponse;
import org.springframework.validation.annotation.Validated;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;

/**
 * 商品相关开发接口
 * Created by guoyanfei .
 * 2022/12/12 .
 */
@Validated
@AdvancedFeignClient
public interface RemoteGoodsOpenService {

    /**
     * 分页查询获取商品
     *
     * @param pageRequest 查询参数
     * @return 商品数据
     */
    PageResponse<GoodsOpenDTO> page(@Valid GoodsOpenQueryRequest pageRequest) throws BizException;

    /**
     * 根据商品id查询单个商品
     *
     * @param spuCode 商品id
     * @return 单个商品数据
     */
    GoodsOpenDTO get(@NotBlank(message = "【spuCode】不能为空") String spuCode) throws BizException;
}
