package cn.com.duiba.goods.open.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.open.api.dto.ObjectOrderCreateDTO;
import cn.com.duiba.goods.open.api.dto.OrderCancelDTO;
import cn.com.duiba.goods.open.api.dto.OrderCompleteDTO;
import cn.com.duiba.goods.open.api.dto.OrderConfirmDTO;
import org.springframework.validation.annotation.Validated;

import javax.validation.Valid;

/**
 * 订单相关开放接口
 * Created by guoyanfei .
 * 2022/12/12 .
 */
@Validated
@AdvancedFeignClient
public interface RemoteOrderOpenService {

    /**
     * 实物订单下单
     *
     * @param dto 下单所需参数
     * @return 订单号
     * @throws BizException 业务异常
     */
    String objectCreate(@Valid ObjectOrderCreateDTO dto) throws BizException;

    /**
     * 确认订单（订单状态 已下单 -> 待发货）
     * 一般情况用于订单审核等场景
     *
     * @param dto 请求参数
     * @throws BizException 业务异常
     */
    void confirm(@Valid OrderConfirmDTO dto) throws BizException;

    /**
     * 完成订单
     *
     * @param dto 请求参数
     * @throws BizException 业务异常
     */
    void complete(@Valid OrderCompleteDTO dto) throws BizException;

    /**
     * 取消订单
     *
     * @param dto 请求参数
     * @throws BizException 业务异常
     */
    void cancel(@Valid OrderCancelDTO dto) throws BizException;
}
