package cn.com.duiba.goods.open.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.goods.open.api.dto.GoodsReturnDTO;
import cn.com.duiba.goods.open.api.dto.RefundOrderCancelDTO;
import cn.com.duiba.goods.open.api.dto.RefundOrderCreateDTO;
import org.springframework.validation.annotation.Validated;

import javax.validation.Valid;

/**
 * 售后相关开放接口
 * Created by guoyanfei .
 * 2022/12/13 .
 */
@Validated
@AdvancedFeignClient
public interface RemoteRefundOpenService {

    /**
     * 创建售后订单
     * 一般在发起售后的时候调用
     *
     * @param dto 售后单创建参数
     * @return 售后单号
     * @throws BizException 业务异常
     */
    String create(@Valid RefundOrderCreateDTO dto) throws BizException;

    /**
     * 取消售后
     *
     * @param refundOrderNo 售后单号
     * @throws BizException 业务异常
     */
    void cancel(@Valid RefundOrderCancelDTO dto) throws BizException;

    /**
     * 退货
     * 一般在用户发出退货单的时候调用
     *
     * @param dto 商品退货信息
     * @throws BizException 业务异常
     */
    void returnGoods(@Valid GoodsReturnDTO dto) throws BizException;

}
