/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.open.api.support;

import com.alibaba.ttl.TransmittableThreadLocal;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang3.StringUtils;

public class OpenApiPermissionContext {
    private String apiKey;
    private Long timestamp;
    private String sign;

    private OpenApiPermissionContext() {
    }

    public static OpenApiPermissionContext get() {
        return (OpenApiPermissionContext)TransmittableThreadLocalHolder.threadLocal2OpenApiPermission.get();
    }

    public static boolean isExisted() {
        return TransmittableThreadLocalHolder.threadLocal2OpenApiPermission.get() != null;
    }

    public static void set(String apiKey, Long timestamp, String sign) {
        if (StringUtils.isBlank((CharSequence)apiKey) || timestamp == null || StringUtils.isBlank((CharSequence)sign)) {
            throw new NullArgumentException("\u53c2\u6570\u4e0d\u5168\uff0c\u65e0\u6cd5\u8bbe\u7f6e\u6743\u9650\u53c2\u6570");
        }
        OpenApiPermissionContext c = (OpenApiPermissionContext)TransmittableThreadLocalHolder.threadLocal2OpenApiPermission.get();
        if (c == null) {
            c = new OpenApiPermissionContext();
        }
        c.apiKey = apiKey;
        c.timestamp = timestamp;
        c.sign = sign;
        TransmittableThreadLocalHolder.threadLocal2OpenApiPermission.set((Object)c);
    }

    public static void remove() {
        TransmittableThreadLocalHolder.threadLocal2OpenApiPermission.remove();
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public String getSign() {
        return this.sign;
    }

    private static class TransmittableThreadLocalHolder {
        protected static final TransmittableThreadLocal<OpenApiPermissionContext> threadLocal2OpenApiPermission = new TransmittableThreadLocal();

        private TransmittableThreadLocalHolder() {
        }
    }
}

