/**
 * Project Name:H5Game-center-api File Name:CommonListDto.java Package Name:cn.com.duiba.H5Game.center.api.domain.dto
 * Date:2016年11月14日下午2:19:25 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.h5game.center.api.domain.dto;

import java.io.Serializable;
import java.util.ArrayList;

/**
 * ClassName:CommonListDto <br/>
 * Function: 通用的分页查询列表结果DTO. <br/>
 * Reason: TODO ADD REASON. <br/>
 * Date: 2016年11月14日 下午2:19:25 <br/>
 *
 * @author Zhuzhiyong
 * @version
 * @param <T> the generic type
 * @see
 * @since JDK 1.6
 */
public class CommonListDto<T> implements Serializable {

    /** The Constant serialVersionUID. */
    private static final long serialVersionUID = 4790213632624332703L;

    /** 列表结果. */
    // 为了解决findbug报的未实例化
    private ArrayList<T>      list             = new ArrayList<T>();

    /** 总数，不是list大小. */
    private Integer           totalCount       = Integer.valueOf(0);

    /**
     * list.
     *
     * @return the list
     */
    public ArrayList<T> getList() {
        return list;
    }

    /**
     * list.
     *
     * @param list the list to set
     */
    public void setList(ArrayList<T> list) {
        this.list = list;
    }

    /**
     * totalCount.
     *
     * @return the totalCount
     */
    public Integer getTotalCount() {
        return totalCount;
    }

    /**
     * totalCount.
     *
     * @param totalCount the totalCount to set
     */
    public void setTotalCount(Integer totalCount) {
        this.totalCount = totalCount;
    }

    /**
     * TODO 简单描述该方法的实现功能（可选）.
     *
     * @return the string
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CommonListDto [list=");
        builder.append(list);
        builder.append(", totalCount=");
        builder.append(totalCount);
        builder.append("]");
        return builder.toString();
    }
}
