/**
 * Project Name:H5Game-center-api File Name:H5GameInfoDto.java Package Name:cn.com.duiba.H5Game.center.api.domain.dto
 * Date:2016年11月14日下午2:10:14 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.h5game.center.api.domain.dto.gamecenter;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * ClassName:H5GameInfoDto <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason: TODO ADD REASON. <br/>
 * Date: 2016年11月14日 下午2:10:14 <br/>
 *
 * @author Zhuzhiyong
 * @version
 * @see
 * @since JDK 1.6
 */
public class H5GameInfoDto implements Serializable {

    /** The Constant serialVersionUID. */
    private static final long serialVersionUID = 1732153804627567185L;

    /** 类型：网游. */
    public static final int   TYPE_ONLINE_GAME = 1;
    /** 类型：小游戏. */
    public static final int   TYPE_LITTLE_GAME = 2;

    /** 逻辑主键. */
    private Long              id;

    /** 标题. */
    private String            title;

    /** 副标题. */
    private String            subTitle;

    /** 游戏链接. */
    private String            link;

    /** 类型：1.小游戏; 2.网游. */
    private Integer           type;

    /** 角标. */
    private List<Superscript> superscriptList;

    /** 标签. */
    private String            tag;

    /** ICON图标. */
    private String            iconImg;

    /** Banner图. */
    private String            bannerImg;

    /** 创建时间. */
    private Date              gmtCreate;

    /** 更新时间. */
    private Date              gmtModified;

    /**
     * id.
     *
     * @return the id
     */
    public Long getId() {
        return id;
    }

    /**
     * id.
     *
     * @param id the id to set
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * title.
     *
     * @return the title
     */
    public String getTitle() {
        return title;
    }

    /**
     * title.
     *
     * @param title the title to set
     */
    public void setTitle(String title) {
        this.title = title;
    }

    /**
     * subTitle.
     *
     * @return the subTitle
     */
    public String getSubTitle() {
        return subTitle;
    }

    /**
     * subTitle.
     *
     * @param subTitle the subTitle to set
     */
    public void setSubTitle(String subTitle) {
        this.subTitle = subTitle;
    }

    /**
     * link.
     *
     * @return the link
     */
    public String getLink() {
        return link;
    }

    /**
     * link.
     *
     * @param link the link to set
     */
    public void setLink(String link) {
        this.link = link;
    }

    /**
     * type.
     *
     * @return the type
     */
    public Integer getType() {
        return type;
    }

    /**
     * type.
     *
     * @param type the type to set
     */
    public void setType(Integer type) {
        this.type = type;
    }

    /**
     * superscriptList.
     *
     * @return the superscriptList
     */
    public List<Superscript> getSuperscriptList() {
        return superscriptList;
    }

    /**
     * superscriptList.
     *
     * @param superscriptList the superscriptList to set
     */
    public void setSuperscriptList(List<Superscript> superscriptList) {
        this.superscriptList = superscriptList;
    }

    /**
     * tag.
     *
     * @return the tag
     */
    public String getTag() {
        return tag;
    }

    /**
     * tag.
     *
     * @param tag the tag to set
     */
    public void setTag(String tag) {
        this.tag = tag;
    }

    /**
     * iconImg.
     *
     * @return the iconImg
     */
    public String getIconImg() {
        return iconImg;
    }

    /**
     * iconImg.
     *
     * @param iconImg the iconImg to set
     */
    public void setIconImg(String iconImg) {
        this.iconImg = iconImg;
    }

    /**
     * bannerImg.
     *
     * @return the bannerImg
     */
    public String getBannerImg() {
        return bannerImg;
    }

    /**
     * bannerImg.
     *
     * @param bannerImg the bannerImg to set
     */
    public void setBannerImg(String bannerImg) {
        this.bannerImg = bannerImg;
    }

    /**
     * gmtCreate.
     *
     * @return the gmtCreate
     */
    public Date getGmtCreate() {
        return gmtCreate;
    }

    /**
     * gmtCreate.
     *
     * @param gmtCreate the gmtCreate to set
     */
    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    /**
     * gmtModified.
     *
     * @return the gmtModified
     */
    public Date getGmtModified() {
        return gmtModified;
    }

    /**
     * gmtModified.
     *
     * @param gmtModified the gmtModified to set
     */
    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    /**
     * TODO 简单描述该方法的实现功能（可选）.
     *
     * @return the string
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("H5GameInfoEntity [id=");
        builder.append(id);
        builder.append(", title=");
        builder.append(title);
        builder.append(", subTitle=");
        builder.append(subTitle);
        builder.append(", link=");
        builder.append(link);
        builder.append(", type=");
        builder.append(type);
        builder.append(", superscriptList=");
        builder.append(superscriptList);
        builder.append(", tag=");
        builder.append(tag);
        builder.append(", iconImg=");
        builder.append(iconImg);
        builder.append(", bannerImg=");
        builder.append(bannerImg);
        builder.append(", gmtCreate=");
        builder.append(gmtCreate);
        builder.append(", gmtModified=");
        builder.append(gmtModified);
        builder.append("]");
        return builder.toString();
    }

    /**
     * The Class Superscript.
     */
    public static class Superscript implements Serializable {

        private static final long serialVersionUID = -4842369605611071507L;

        /** 角标名称. */
        private String            text;

        /** 角标颜色. */
        private String            colour;

        /**
         * Instantiates a new superscript.
         */
        public Superscript() {
        }

        /**
         * Instantiates a new superscript.
         *
         * @param text the text
         * @param colour the colour
         */
        public Superscript(String text, String colour) {
            this.text = text;
            this.colour = colour;
        }

        /**
         * text.
         *
         * @return the text
         */
        public String getText() {
            return text;
        }

        /**
         * text.
         *
         * @param text the text to set
         */
        public void setText(String text) {
            this.text = text;
        }

        /**
         * colour.
         *
         * @return the colour
         */
        public String getColour() {
            return colour;
        }

        /**
         * colour.
         *
         * @param colour the colour to set
         */
        public void setColour(String colour) {
            this.colour = colour;
        }
    }
}
