/**
 * Project Name:H5Game-center-api File Name:H5GameResourceDto.java Package
 * Name:cn.com.duiba.H5Game.center.api.domain.dto Date:2016年11月14日下午2:36:03 Copyright (c) 2016, duiba.com.cn All Rights
 * Reserved.
 */

package cn.com.duiba.h5game.center.api.domain.dto.gamecenter;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import cn.com.duiba.h5game.center.api.domain.dto.gamecenter.H5GameInfoDto.Superscript;

/**
 * ClassName:H5GameResourceDto <br/>
 * Function: h5游戏资源信息，包含游戏基本信息. <br/>
 * Reason: TODO ADD REASON. <br/>
 * Date: 2016年11月14日 下午2:36:03 <br/>
 * 
 * @author Zhuzhiyong
 * @version
 * @since JDK 1.6
 * @see
 */
public class H5GameResourceDto implements Serializable {

    private static final long serialVersionUID         = -8547817571189634834L;
    /** banner区. */
    public static final int   RESOURCE_TYPE_BANNER     = 1;
    /** 今日推荐. */
    public static final int   RESOURCE_TYPE_RECOMMEND  = 2;
    /** 网游. */
    public static final int   RESOURCE_TYPE_ONLINE     = 3;
    /** 小游戏. */
    public static final int   RESOURCE_TYPE_LITTLEGAME = 4;
    /** 腰封. */
    public static final int   RESOURCE_TYPE_BELT       = 5;
    /** 腰封1. */
    public static final int   BELT_NO_ONE              = 1;
    /** 腰封2. */
    public static final int   BELT_NO_TWO              = 2;

    /** 资源位逻辑主键. */
    private Long              id;

    /** h5游戏ID. */
    private Long              h5gameId;

    /** 资源类型. */
    private Integer           resourceType;

    /** 腰封图. */
    private String            beltImg;

    /** 腰封编号. */
    private Integer           beltNo;

    /** 优先级. */
    private Integer           payload;

    /** 创建时间. */
    private Date              gmtCreate;

    /** 更新时间. */
    private Date              gmtModified;

    /** 游戏标题. */
    private String            title;

    /** 游戏副标题. */
    private String            subTitle;

    /** 游戏链接. */
    private String            link;

    /** 游戏类型：1.小游戏; 2.网游. */
    private Integer           type;

    /** 游戏角标. */
    private List<Superscript> superscriptList;

    /** 游戏标签. */
    private String            tag;

    /** 游戏ICON图标. */
    private String            iconImg;

    /** 游戏Banner图. */
    private String            bannerImg;

    /**
     * id.
     *
     * @return the id
     */
    public Long getId() {
        return id;
    }

    /**
     * id.
     *
     * @param id the id to set
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * h5gameId.
     *
     * @return the h5gameId
     */
    public Long getH5gameId() {
        return h5gameId;
    }

    /**
     * h5gameId.
     *
     * @param h5gameId the h5gameId to set
     */
    public void setH5gameId(Long h5gameId) {
        this.h5gameId = h5gameId;
    }

    /**
     * resourceType.
     *
     * @return the resourceType
     */
    public Integer getResourceType() {
        return resourceType;
    }

    /**
     * resourceType.
     *
     * @param resourceType the resourceType to set
     */
    public void setResourceType(Integer resourceType) {
        this.resourceType = resourceType;
    }

    /**
     * beltImg.
     *
     * @return the beltImg
     */
    public String getBeltImg() {
        return beltImg;
    }

    /**
     * beltImg.
     *
     * @param beltImg the beltImg to set
     */
    public void setBeltImg(String beltImg) {
        this.beltImg = beltImg;
    }

    /**
     * beltNo.
     *
     * @return the beltNo
     */
    public Integer getBeltNo() {
        return beltNo;
    }

    /**
     * beltNo.
     *
     * @param beltNo the beltNo to set
     */
    public void setBeltNo(Integer beltNo) {
        this.beltNo = beltNo;
    }

    /**
     * payload.
     *
     * @return the payload
     */
    public Integer getPayload() {
        return payload;
    }

    /**
     * payload.
     *
     * @param payload the payload to set
     */
    public void setPayload(Integer payload) {
        this.payload = payload;
    }

    /**
     * gmtCreate.
     *
     * @return the gmtCreate
     */
    public Date getGmtCreate() {
        return gmtCreate;
    }

    /**
     * gmtCreate.
     *
     * @param gmtCreate the gmtCreate to set
     */
    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    /**
     * gmtModified.
     *
     * @return the gmtModified
     */
    public Date getGmtModified() {
        return gmtModified;
    }

    /**
     * gmtModified.
     *
     * @param gmtModified the gmtModified to set
     */
    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    /**
     * title.
     *
     * @return the title
     */
    public String getTitle() {
        return title;
    }

    /**
     * title.
     *
     * @param title the title to set
     */
    public void setTitle(String title) {
        this.title = title;
    }

    /**
     * subTitle.
     *
     * @return the subTitle
     */
    public String getSubTitle() {
        return subTitle;
    }

    /**
     * subTitle.
     *
     * @param subTitle the subTitle to set
     */
    public void setSubTitle(String subTitle) {
        this.subTitle = subTitle;
    }

    /**
     * link.
     *
     * @return the link
     */
    public String getLink() {
        return link;
    }

    /**
     * link.
     *
     * @param link the link to set
     */
    public void setLink(String link) {
        this.link = link;
    }

    /**
     * type.
     *
     * @return the type
     */
    public Integer getType() {
        return type;
    }

    /**
     * type.
     *
     * @param type the type to set
     */
    public void setType(Integer type) {
        this.type = type;
    }

    /**
     * superscriptList.
     *
     * @return the superscriptList
     */
    public List<Superscript> getSuperscriptList() {
        return superscriptList;
    }

    /**
     * superscriptList.
     *
     * @param superscriptList the superscriptList to set
     */
    public void setSuperscriptList(List<Superscript> superscriptList) {
        this.superscriptList = superscriptList;
    }

    /**
     * tag.
     *
     * @return the tag
     */
    public String getTag() {
        return tag;
    }

    /**
     * tag.
     *
     * @param tag the tag to set
     */
    public void setTag(String tag) {
        this.tag = tag;
    }

    /**
     * iconImg.
     *
     * @return the iconImg
     */
    public String getIconImg() {
        return iconImg;
    }

    /**
     * iconImg.
     *
     * @param iconImg the iconImg to set
     */
    public void setIconImg(String iconImg) {
        this.iconImg = iconImg;
    }

    /**
     * bannerImg.
     *
     * @return the bannerImg
     */
    public String getBannerImg() {
        return bannerImg;
    }

    /**
     * bannerImg.
     *
     * @param bannerImg the bannerImg to set
     */
    public void setBannerImg(String bannerImg) {
        this.bannerImg = bannerImg;
    }

    /**
     * TODO 简单描述该方法的实现功能（可选）.
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("H5GameResourceDto [id=");
        builder.append(id);
        builder.append(", h5gameId=");
        builder.append(h5gameId);
        builder.append(", resourceType=");
        builder.append(resourceType);
        builder.append(", beltImg=");
        builder.append(beltImg);
        builder.append(", beltNo=");
        builder.append(beltNo);
        builder.append(", payload=");
        builder.append(payload);
        builder.append(", gmtCreate=");
        builder.append(gmtCreate);
        builder.append(", gmtModified=");
        builder.append(gmtModified);
        builder.append(", title=");
        builder.append(title);
        builder.append(", subTitle=");
        builder.append(subTitle);
        builder.append(", link=");
        builder.append(link);
        builder.append(", type=");
        builder.append(type);
        builder.append(", superscriptList=");
        builder.append(superscriptList);
        builder.append(", tag=");
        builder.append(tag);
        builder.append(", iconImg=");
        builder.append(iconImg);
        builder.append(", bannerImg=");
        builder.append(bannerImg);
        builder.append("]");
        return builder.toString();
    }
}
