/**
 * Project Name:H5Game-center-api File Name:RemoteH5GameBackendService.java Package
 * Name:cn.com.duiba.H5Game.center.api.remoteservice Date:2016年11月14日下午2:41:42 Copyright (c) 2016, duiba.com.cn All
 * Rights Reserved.
 */

package cn.com.duiba.h5game.center.api.remoteservice.gamecenter;

import java.util.Map;
import java.util.Set;

import cn.com.duiba.h5game.center.api.domain.dto.CommonListDto;
import cn.com.duiba.h5game.center.api.domain.dto.gamecenter.H5GameInfoDto;
import cn.com.duiba.h5game.center.api.domain.dto.gamecenter.H5GameResourceDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteH5GameBackendService <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason: TODO ADD REASON. <br/>
 * Date: 2016年11月14日 下午2:41:42 <br/>
 *
 * @author Zhuzhiyong
 * @version
 * @see
 * @since JDK 1.6
 */
public interface RemoteH5GameBackendService {

    /**
     * 管理端：查询指定类型H5游戏列表.
     *
     * @param type 游戏资源类型：1-5
     * @param offset the offset
     * @param max the max
     * @return the common list dto
     */
    DubboResult<CommonListDto<H5GameResourceDto>> findGameResourceList(int type, int offset, int max);

    /**
     * 管理端：删除游戏资源.
     *
     * @param id 游戏资源ID.
     * @return the dubbo result
     */
    DubboResult<Boolean> deleteResource(Long id);

    /**
     * 管理端：更新游戏资源信息.<br>
     * 目前支撑更新腰封信息.
     *
     * @param h5GameResourceDto the h 5 game resource dto
     * @return the dubbo result
     */
    DubboResult<Boolean> updateResource(H5GameResourceDto h5GameResourceDto);

    /**
     * 管理端：更新资源位优先级.<br>
     * id和payload必传，其他值不传
     *
     * @param one the one
     * @param two the two
     * @return the dubbo result
     */
    DubboResult<Boolean> updatePayload(H5GameResourceDto one, H5GameResourceDto two);

    /**
     * 管理端：新增游戏资源.<br>
     * 对于非腰封资源，只需要h5gameId字段; 对于腰封资源，还需要beltImg和beltNo<br>
     *
     * @param h5GameResourceDto the h 5 game resource dto
     * @return the dubbo result
     */
    DubboResult<Long> addResource(H5GameResourceDto h5GameResourceDto);

    /**
     * 管理端：根据H5游戏ID查询信息.
     *
     * @param id the id
     * @return the dubbo result
     */
    DubboResult<H5GameInfoDto> findH5Game(Long id);

    /**
     * 管理端：根据H5游戏ID查询信息.<br>
     * 返回为游戏资源ID.<br>
     *
     * @param h5GameInfoDto the h 5 game info dto
     * @return the dubbo result
     */
    DubboResult<Long> addH5Game(H5GameInfoDto h5GameInfoDto);

    /**
     * 管理端：更新H5游戏信息.<br>
     *
     * @param h5GameInfoDto the h 5 game info dto
     * @return the dubbo result
     */
    DubboResult<Boolean> updateH5Game(H5GameInfoDto h5GameInfoDto);

    /**
     * 管理端：删除H5游戏.
     *
     * @param id the id
     * @return the dubbo result
     */
    DubboResult<Boolean> deleteH5Game(Long id);

    /**
     * 分页查询h5游戏.
     *
     * @param offset the offset
     * @param max the max
     * @return the dubbo result
     */
    DubboResult<CommonListDto<H5GameInfoDto>> findH5Game(int offset, int max);

    /**
     * 管理端：查询微信关注弹层代码.<br>
     * 欢乐微游-其他-关注管理.<br>
     *
     * @return the dubbo result
     */
    DubboResult<String> findWeixinFollowCode();

    /**
     * 管理端：更新微信关注弹层代码.<br>
     * 欢乐微游-其他-关注管理.<br>
     *
     * @param code the code
     * @return the dubbo result
     */
    DubboResult<Boolean> updateWeixinFollowCode(String code);

    /**
     * 管理端：查询游戏列表页banner图.<br>
     * 欢乐微游-其他-游戏列表管理-图片管理.<br>
     *
     * @return the dubbo result
     */
    DubboResult<String> findGameListPageBannerImg();

    /**
     * 管理端：更新游戏列表页banner图.<br>
     * 欢乐微游-其他-游戏列表管理-图片管理.<br>
     *
     * @param bannerImg the banner img
     * @return the dubbo result
     */
    DubboResult<Boolean> updateGameListPageBannerImg(String bannerImg);

    /**
     * 更新模块名称.
     *
     * @param resourceType 模块类型
     * @param name 模块名称
     * @return the dubbo result
     */
    DubboResult<Boolean> updateModuleName(int resourceType, String name);

    /**
     * 批量查询模块名称.
     *
     * @param resourceTypes the resource types
     * @return the dubbo result
     */
    DubboResult<Map<Integer, String>> findModuleNames(Set<Integer> resourceTypes);

    /**
     * 搜索H5游戏，可以根据ID或者title.
     *
     * @param text 搜索文本
     * @param offset the offset
     * @param max the max
     * @return the dubbo result
     */
    DubboResult<CommonListDto<H5GameInfoDto>> searchH5Game(String text, int offset, int max);
}
