/**
 * Project Name:H5Game-center-api File Name:RemoteH5GameService.java Package
 * Name:cn.com.duiba.H5Game.center.api.remoteservice Date:2016年11月14日下午2:41:17 Copyright (c) 2016, duiba.com.cn All
 * Rights Reserved.
 */

package cn.com.duiba.h5game.center.api.remoteservice.gamecenter;

import cn.com.duiba.h5game.center.api.domain.dto.CommonListDto;
import cn.com.duiba.h5game.center.api.domain.dto.gamecenter.H5GameInfoDto;
import cn.com.duiba.h5game.center.api.domain.dto.gamecenter.H5GameResourceDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteH5GameService <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason: TODO ADD REASON. <br/>
 * Date: 2016年11月14日 下午2:41:17 <br/>
 * 
 * @author Zhuzhiyong
 * @version
 * @since JDK 1.6
 * @see
 */
public interface RemoteH5GameService {

    /**
     * 手机端：查询指定类型H5游戏列表.
     *
     * @param type 游戏资源类型：1-5
     * @param offset the offset
     * @param max the max
     * @return the common list dto
     */
    DubboResult<CommonListDto<H5GameResourceDto>> findGameResourceList(int type, int offset, int max);

    /**
     * 手机端：查询微信关注弹层代码.<br>
     * 欢乐微游-其他-关注管理.<br>
     *
     * @return the dubbo result
     */
    DubboResult<String> findWeixinFollowCode();

    /**
     * 手机：查询游戏列表页banner图.<br>
     * 欢乐微游-其他-游戏列表管理-图片管理.<br>
     *
     * @return the dubbo result
     */
    DubboResult<String> findGameListPageBannerImg();

    /**
     * 手机端：查询H5游戏列表.
     *
     * @param type 游戏类型：1网游;2小游戏
     * @param offset the offset
     * @param max the max
     * @return the common list dto
     */
    DubboResult<CommonListDto<H5GameInfoDto>> findGameInfoList(int type, int offset, int max);
}
