package cn.com.duiba.hdtool.center.api.remoteservice.hdtool;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.hdtool.center.api.dto.hdtool.DuibaHdtoolDto;

import java.util.List;

/**
 * ClassName:RemoteDuibaHdtoolService.java <br/>
 *
 * 活动工具 手机端接口 有redis缓存
 *
 * @author  gey
 * @date 创建时间：2018年3月9日 上午11:11:43
 * @version 1.0
 * @parameter
 * @since   JDK 1.6
 */
@AdvancedFeignClient
public interface RemoteDuibaHdtoolService {

    /**
     *
     * @Description: 根据活动id 查询活动配置信息
     *
     * @param id
     * @return
     * @since JDK 1.8
     */
    DuibaHdtoolDto findDuibaHdToolById(Long id) throws BizException;

    /**
     *
     * @Description: 根据活动id、appId 查询活动开发者定向配置信息
     *
     * @param id
     * @return
     * @since JDK 1.8
     */
    DuibaHdtoolDto findSpecifyConfigByIdAndAppId(Long id,Long appId) throws BizException;

    /**
     * 根据活动id批量查询活动信息
     * 最多查询20个,若超过20个返回空集合
     * 接口有1分钟redis缓存，修改单个活动不会清除缓存，数据敏感的场景慎用
     * @return
     */
    List<DuibaHdtoolDto> findByIdsCache(List<Long> ids);


}
