package cn.com.duiba.hdtool.center.api.remoteservice.hdtool;

import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.hdtool.center.api.dto.hdtool.HdtoolSkinDefaultDto;
import cn.com.duiba.hdtool.center.api.dto.hdtool.HdtoolSkinDefaultTypeNameDto;
import cn.com.duiba.hdtool.center.api.params.PageParams;

import java.util.List;

/**
 * ClassName:RemoteHdtoolSkinDefaultDataSerivce<br/>
 *
 * @author gey
 *
 * @version 1.0
 *
 * @Description: 活动工具 默认皮肤模板接口 默认皮肤 支持可配置
 *
 * @date 创建时间：2018/3/16 9:58
 *
 * @since JDK 1.8
 **/
@AdvancedFeignClient
public interface RemoteHdtoolSkinDefaultDataNewSerivce {

	/**
	 *
	 * createHdtoolDefaultSkin:(这里用一句话描述这个方法的作用). <br/>
	 * 创建一条默认皮肤模版数据
	 * 
	 * @param hdtoolSkinDefaultDto
	 * @return
	 * @since JDK 1.6
	 */
	public Integer createHdtoolDefaultSkin(HdtoolSkinDefaultDto hdtoolSkinDefaultDto);

	/**
	 *
	 * createHdtoolDefaultSkin:(这里用一句话描述这个方法的作用). <br/>
	 * 更新一条默认皮肤模版数据
	 * 
	 * @param hdtoolSkinDefaultDto
	 * @return
	 * @since JDK 1.6
	 */
	public Integer updateHdtoolDefaultSkin(HdtoolSkinDefaultDto hdtoolSkinDefaultDto) throws BizException;

	/**
	 * 分页查询
	 * 
	 * @author gey
	 *
	 * @param params
	 *
	 * @return
	 * @since JDK 1.6
	 */
	public Page<HdtoolSkinDefaultDto> queryListPagnation(PageParams params);


	/**
	 * 查询 所有活动类型名称
	 * @return
	 */
	List<HdtoolSkinDefaultTypeNameDto> queryNameList();


	
	/**
	 * 开启关闭
	 * 
	 * @author gey
	 *
	 * @param skinStatus
	 * @param templateType
	 *
	 * @return
	 * @since JDK 1.6
	 */
	public Boolean openAndClose(Boolean skinStatus, String templateType);
	
	/**
	 * 查询默认活动配置
	 * 
	 * @author gey
	 * @param templateType
	 * 
	 * @return
	 * @since JDK 1.6
	 */
	public HdtoolSkinDefaultDto findByTemplateType(String templateType)throws BizException;
	
}