package cn.com.duiba.hdtool.center.api.remoteservice.record;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.hdtool.center.api.dto.record.HdtoolConsumerRecordDto;
import cn.com.duiba.hdtool.center.api.params.UserScoreQueryParam;

import javax.annotation.CheckForNull;

/**
 * ClassName:RemoteDuibaNgameRecordService<br/>
 *
 * @author gey
 * @version 1.0
 * @Description: 游戏订单配置信息
 * @date 创建时间：2018/9/25  10:13
 * @since JDK 1.8
 **/
@AdvancedFeignClient
public interface RemoteDuibaHdtoolRecordService {
	
	/**
	 *
	 * findRecord:(这里用一句话描述这个方法的作用). <br/>
	 * 根据ID查询订单
	 * @param id
	 * @return
	 * @throws  BizException
	 * @since JDK 1.8
	 */
	public HdtoolConsumerRecordDto findRecord(Long id) throws BizException;

	/**
	 *
	 * createRecord:(创建订单). <br/>
	 *
	 * @param hdtoolConsumerRecordDto
	 * @return
	 * @since JDK 1.8
	 */
	public Integer createRecord(HdtoolConsumerRecordDto hdtoolConsumerRecordDto)throws BizException;
	
	/**
	 *
	 * updateRecord:(创建订单). <br/>
	 *
	 * @param hdtoolConsumerRecordDto
	 * @return
	 * @since JDK 1.8
	 */
	public Long updateRecord(HdtoolConsumerRecordDto hdtoolConsumerRecordDto)throws BizException;

	/**
	 * 根据用户id和兑吧活动id查询用户最高分或最低分
	 * 默认查询最高分可通过修改入参选择 {@link UserScoreQueryParam#sortAsc}
	 *
	 * @return
	 */
	@CheckForNull
	Long findUserScoreByCidAndHdToolId(UserScoreQueryParam param);
}
