package cn.com.duiba.hdtool.center.api.params;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

/**
 * @Author: fss
 * @Date: 2022/5/12 16
 * @Description: 抽奖活动数据查询
 */
public class HsbcLottoDataParam implements Serializable {

    private static final long serialVersionUID = -1L;

    private Long appId;

    private Date startDate;

    private Date endDate;

    private Long activityId;

    /**
     * 页码
     */
    private Integer pageNum;
    /**
     * 每页数据量
     */
    private Integer pageSize;
    /**
     * 分页偏移量
     */
    private Integer offset;

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Integer getOffset() {
        if (Objects.nonNull(pageNum) && Objects.nonNull(pageSize)) {
            return (pageNum - 1) * pageSize;
        }
        return offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }
}
