package cn.com.duiba.hdtool.center.api.remoteservice.hdtool;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.api.bo.BizResultDto;
import cn.com.duiba.hdtool.center.api.dto.hdtool.SpecifyConfigDto;

import java.util.List;

/**
 * ClassName:RemoteSpecifyConfigBackendService.java <br/>
 * 管理端接口
 * 开发者定向配置
 *
 * @author xukaiqiang
 * @version 1.0
 * @date 创建时间：2018年05月23日 14:17
 * @since JDK 1.8
 */
@AdvancedFeignClient
public interface RemoteSpecifyConfigBackendService {

    /**
     * @param id
     * @Description: 根据活动id 查询APP配置信息
     */
    BizResultDto<List<SpecifyConfigDto>> listByActivityIdApi(Long id);

    /**
     * @param list
     * @Description: 批量插入APP配置信息
     */
    BizResultDto<String> insertBatchApi(List<SpecifyConfigDto> list);

    /**
     * @param specifyConfigDto
     * @Description: 根据配置信息编号编辑
     */
    BizResultDto<String> updateApi(SpecifyConfigDto specifyConfigDto);

    /**
     * @param id
     * @Description: 根据配置信息编号删除
     */
    BizResultDto<String> deleteApi(Long id);

    /**
     * @param id
     * @Description: 根据id 查询APP配置信息
     */
    BizResultDto<SpecifyConfigDto> findByIdApi(Long id);
    
    /**
     * @param id
     * @Description: 根据活动id 查询APP配置信息
     */
    BizResultDto<SpecifyConfigDto> findByActivityIdAndAppIDApi(Long activityId, Long appId);

    /**
     * @param list
     * @Description: 批量插入APP配置信息
     */
    BizResultDto<String> insertApi(SpecifyConfigDto specify);
}
