package cn.com.duiba.hdtool.center.api.enums;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import java.util.List;
import java.util.Map;

/**
 * ClassName:BetStatusEnum<br/>
 *
 * @author xukaiqiang
 *
 * @version 1.0
 *
 * @Description: 结算状态：0，未结算；1，开奖；2，退单
 *
 * @date 创建时间：2018/05/29  13:43
 *
 * @since JDK 1.8
 **/
public enum BetStatusEnum {

	UN_LOTTERY(0,"未结算"),
	RUN_LOTTERY(1,"开奖"),
	CHARGE_BACK(2,"退单");

	private Integer key;

	private String desc;

	BetStatusEnum(Integer key, String desc) {
		this.key = key;
		this.desc = desc;
	}

	public Integer getKey() {
		return key;
	}

	public String getDesc() {
		return desc;
	}

}
