package cn.com.duiba.hdtool.center.api.remoteservice.hdtool;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.hdtool.center.api.dto.hdtool.HdtoolSkinDefaultDto;
import cn.com.duiba.hdtool.center.api.params.PageParams;

import java.util.List;
import java.util.Map;

/**
 * ClassName:RemoteHdtoolSkinDefaultDataSerivce<br/>
 *
 * @author gey
 *
 * @version 1.0
 *
 * @Description: 活动工具 默认皮肤模板接口
 *
 * @date 创建时间：2018/3/16  9:58
 *
 * @since JDK 1.8
 **/
@AdvancedFeignClient
public interface RemoteHdtoolSkinDefaultDataSerivce {

    /**
     *
     * createHdtoolDefaultSkin:(这里用一句话描述这个方法的作用). <br/>
     * 创建一条默认皮肤模版数据
     * @param hdtoolSkinDefaultDto
     * @return
     * @since JDK 1.6
     */
    public HdtoolSkinDefaultDto createHdtoolDefaultSkin(HdtoolSkinDefaultDto hdtoolSkinDefaultDto);

    /**
     *
     * createHdtoolDefaultSkin:(这里用一句话描述这个方法的作用). <br/>
     * 更新一条默认皮肤模版数据
     * @param hdtoolSkinDefaultDto
     * @return
     * @since JDK 1.6
     */
    public Integer updateHdtoolDefaultSkin(HdtoolSkinDefaultDto hdtoolSkinDefaultDto);

    /**
     * 查询默认活动配置
     * @author zp
     * @param templateType
     * @param type
     * @return
     * @since JDK 1.6
     */
    public HdtoolSkinDefaultDto queryHdtoolBaseSkin(String templateType,String type) throws BizException;

    /**
     * 分页查询
     * @author zp
     *
     * @param params
     *
     * @return
     * @since JDK 1.6
     */
    public List<HdtoolSkinDefaultDto> queryListPagnation(PageParams params);

    /**
     * 查询总条数
     * @author zp
     * @return
     * @since JDK 1.6
     */
    public Integer queryListCount();

    /**
     * 查询默认活动配置
     * @author zp
     * @return
     * @since JDK 1.6
     */
    public Map<String,String> queryHdtoolBaseSkinMap();
}
