package cn.com.duiba.hdtool.center.api.dto;

import java.io.Serializable;

public class BizResultDto<T> implements Serializable {
    private static final long serialVersionUID = 2316596536097261633L;
    private static final String SUCCESS_MSG = "成功";
    /* 是否失败 */
    private Boolean success;
    /* 提示信息 */
    private String msg;
    /* 具体的内容 */
    private T data;

    public boolean isSuccess() {
        return success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public static <T> BizResultDto<T> success(T t) {
        BizResultDto<T> dto = new BizResultDto<>();
        dto.setSuccess(true);
        dto.setMsg(SUCCESS_MSG);
        dto.setData(t);
        return dto;
    }

    public static BizResultDto success() {
        BizResultDto dto = new BizResultDto();
        dto.setSuccess(true);
        dto.setMsg(SUCCESS_MSG);
        return dto;
    }

    public static <T> BizResultDto<T> fail(String msg) {
        BizResultDto<T> dto = new BizResultDto<>();
        dto.setSuccess(false);
        dto.setMsg(msg);
        return dto;
    }

}


