/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.id.idmaker.service.biz;

public class IDWorker {
    private final long machineId;
    private final long bizId;
    private static final long twepoch = 1463485770L;
    private long sequence = 0L;
    public static final long SEQUENCE_BITS = 12L;
    public static final long SEQUENCE_MASK = 4095L;
    private static final long MACHINE_ID_BITS = 3L;
    public static final long MAX_MACHINE_ID = 7L;
    private static final long MACHINE_OFFSET = 4095L;
    private static final long BIZ_ID_BITS = 5L;
    private static final long MAX_BIZ_ID = 31L;
    private static final long BIZ_OFFSET = 32767L;
    private static final long TIMESTAMP_OFFSET = 1048575L;
    private long lastTimestamp = -1L;

    public IDWorker(long machineId, long bizId) {
        if (machineId > 7L || machineId < 0L) {
            throw new IllegalArgumentException(String.format("machine Id can't be greater than %d or less than 0", 7L));
        }
        this.machineId = machineId;
        if (bizId > 31L || bizId < 0L) {
            throw new IllegalArgumentException(String.format("biz Id can't be greater than %d or less than 0", 31L));
        }
        this.bizId = bizId;
    }

    public synchronized long nextId() {
        long timestamp = this.timeGen();
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        if (timestamp < this.lastTimestamp) {
            throw new IllegalStateException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp));
        }
        this.lastTimestamp = timestamp;
        return (timestamp - 1463485770L) * 1048575L + this.bizId * 32767L + this.machineId * 4095L + this.sequence;
    }

    private long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    private long timeGen() {
        return System.currentTimeMillis() / 1000L;
    }

    public static void main(String[] args) {
        IDWorker idWorker = new IDWorker(2L, 2L);
        long l = idWorker.nextId();
        System.out.println(l);
        System.out.println(String.valueOf(l).length());
        System.out.println(Long.MAX_VALUE);
        System.out.println(String.valueOf(Long.MAX_VALUE).length());
        int num = 60;
        long id = 10L;
        long i = id << num;
        System.out.println(4096);
        System.out.println(i >>> num);
        System.out.println(4166);
    }
}

