/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.id.idmaker.service.biz.support;

import cn.com.duiba.id.idmaker.service.biz.support.RedisKeyFactory;
import cn.com.duiba.wolf.redis.RedisClient;
import com.google.common.base.Splitter;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class IDMakerConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(IDMakerConstants.class);
    public static final int DEFAULE_ID = 2;
    private static final Splitter SPLITTER = Splitter.on((String)",").trimResults().omitEmptyStrings();
    @Resource
    private RedisClient redisClient;
    @Value(value="${idmaker.allow.bizid}")
    private String allowBiz;
    @Value(value="${idmaker.machine.ids}")
    private String idmakerMachineIds;
    public int machineId;
    public static final int OK = 1;

    @PostConstruct
    public void init() {
        if (StringUtils.isBlank((CharSequence)this.idmakerMachineIds)) {
            LOGGER.warn("idmaker.machine.id is null {} use default value {}", new Object[]{this.idmakerMachineIds, 2});
            this.machineId = 2;
        } else {
            Iterable split = SPLITTER.split((CharSequence)this.idmakerMachineIds);
            for (String id : split) {
                String lockKey = RedisKeyFactory.idMakerLockKey(id);
                Long incr = this.redisClient.incr(lockKey);
                if (incr.intValue() != 1) continue;
                this.machineId = Integer.valueOf(id);
                break;
            }
        }
        if (this.machineId == 0) {
            this.machineId = 2;
            LOGGER.warn("use default machine ID {}", new Object[]{this.machineId});
        }
        LOGGER.info("machineID {} ", new Object[]{this.machineId});
    }

    public String getIdmakerMachineIds() {
        return this.idmakerMachineIds;
    }

    public void setIdmakerMachineIds(String idmakerMachineIds) {
        this.idmakerMachineIds = idmakerMachineIds;
    }

    public void setMachineId(int machineId) {
        this.machineId = machineId;
    }

    public String getAllowBiz() {
        return this.allowBiz;
    }

    public void setAllowBiz(String allowBiz) {
        this.allowBiz = allowBiz;
    }

    public int getMachineId() {
        return this.machineId;
    }

    @PreDestroy
    public void destory() {
        this.redisClient.del(RedisKeyFactory.idMakerLockKey(String.valueOf(this.machineId)));
    }
}

