/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.disconf.client.scan.inner.statically.impl;

import com.baidu.disconf.client.common.annotations.DisconfFile;
import com.baidu.disconf.client.common.annotations.DisconfFileItem;
import com.baidu.disconf.client.common.constants.SupportFileTypeEnum;
import com.baidu.disconf.client.common.model.DisConfCommonModel;
import com.baidu.disconf.client.common.model.DisconfCenterBaseModel;
import com.baidu.disconf.client.common.model.DisconfCenterFile;
import com.baidu.disconf.client.config.DisClientSysConfig;
import com.baidu.disconf.client.scan.inner.statically.StaticScannerMgr;
import com.baidu.disconf.client.scan.inner.statically.impl.StaticScannerMgrImplBase;
import com.baidu.disconf.client.scan.inner.statically.model.ScanStaticModel;
import com.baidu.disconf.client.store.DisconfStoreProcessorFactory;
import com.baidu.disconf.client.utils.MethodUtils;
import com.baidu.disconf.core.common.constants.DisConfigTypeEnum;
import com.baidu.disconf.core.common.path.DisconfWebPathMgr;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticScannerFileMgrImpl
extends StaticScannerMgrImplBase
implements StaticScannerMgr {
    protected static final Logger LOGGER = LoggerFactory.getLogger(StaticScannerFileMgrImpl.class);

    @Override
    public void scanData2Store(ScanStaticModel scanModel) {
        List<DisconfCenterBaseModel> disconfCenterFiles = StaticScannerFileMgrImpl.getDisconfFiles(scanModel);
        DisconfStoreProcessorFactory.getDisconfStoreFileProcessor().transformScanData(disconfCenterFiles);
    }

    @Override
    public void exclude(Set<String> keySet) {
        DisconfStoreProcessorFactory.getDisconfStoreFileProcessor().exclude(keySet);
    }

    private static List<DisconfCenterBaseModel> getDisconfFiles(ScanStaticModel scanModel) {
        ArrayList<DisconfCenterBaseModel> disconfCenterFiles = new ArrayList<DisconfCenterBaseModel>();
        Set<Class<?>> classSet = scanModel.getDisconfFileClassSet();
        for (Class<?> disconfFile : classSet) {
            Set<Method> methods = scanModel.getDisconfFileItemMap().get(disconfFile);
            if (methods == null) continue;
            DisconfCenterFile disconfCenterFile = StaticScannerFileMgrImpl.transformScanFile(disconfFile, methods);
            disconfCenterFiles.add(disconfCenterFile);
        }
        return disconfCenterFiles;
    }

    private static DisconfCenterFile transformScanFile(Class<?> disconfFileClass, Set<Method> methods) {
        DisconfCenterFile disconfCenterFile = new DisconfCenterFile();
        disconfCenterFile.setCls(disconfFileClass);
        DisconfFile disconfFileAnnotation = disconfFileClass.getAnnotation(DisconfFile.class);
        disconfCenterFile.setFileName(disconfFileAnnotation.filename());
        disconfCenterFile.setCopy2TargetDirPath(disconfFileAnnotation.copy2TargetDirPath().trim());
        disconfCenterFile.setSupportFileTypeEnum(SupportFileTypeEnum.getByFileName(disconfFileAnnotation.filename()));
        DisConfCommonModel disConfCommonModel = StaticScannerFileMgrImpl.makeDisConfCommonModel(disconfFileAnnotation.env(), disconfFileAnnotation.version());
        disconfCenterFile.setDisConfCommonModel(disConfCommonModel);
        String url = DisconfWebPathMgr.getRemoteUrlParameter((String)DisClientSysConfig.getInstance().CONF_SERVER_STORE_ACTION, (String)disConfCommonModel.getApp(), (String)disConfCommonModel.getVersion(), (String)disConfCommonModel.getEnv(), (String)disconfCenterFile.getFileName(), (DisConfigTypeEnum)DisConfigTypeEnum.FILE);
        disconfCenterFile.setRemoteServerUrl(url);
        Field[] expectedFields = disconfFileClass.getDeclaredFields();
        HashMap<String, DisconfCenterFile.FileItemValue> keyMaps = new HashMap<String, DisconfCenterFile.FileItemValue>();
        for (Method method : methods) {
            DisconfCenterFile.FileItemValue fileItemValue;
            Field field = MethodUtils.getFieldFromMethod(method, expectedFields, DisConfigTypeEnum.FILE);
            if (field == null) continue;
            DisconfFileItem disconfFileItem = method.getAnnotation(DisconfFileItem.class);
            String keyName = disconfFileItem.name();
            field.setAccessible(true);
            Method setterMethod = MethodUtils.getSetterMethodFromField(disconfFileClass, field);
            if (Modifier.isStatic(field.getModifiers())) {
                try {
                    fileItemValue = new DisconfCenterFile.FileItemValue(field.get(null), field, setterMethod);
                    keyMaps.put(keyName, fileItemValue);
                }
                catch (Exception e) {
                    LOGGER.error(e.toString());
                }
                continue;
            }
            fileItemValue = new DisconfCenterFile.FileItemValue(null, field, setterMethod);
            keyMaps.put(keyName, fileItemValue);
        }
        disconfCenterFile.setKeyMaps(keyMaps);
        return disconfCenterFile;
    }
}

