/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.recipes.lock;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.recipes.lock.ZooKeeperOperation;

class ProtocolSupport {
    private static final Logger LOG = Logger.getLogger(ProtocolSupport.class);
    protected final ZooKeeper zookeeper;
    private AtomicBoolean closed = new AtomicBoolean(false);
    private long retryDelay = 500L;
    private int retryCount = 10;
    private List<ACL> acl = ZooDefs.Ids.OPEN_ACL_UNSAFE;

    public ProtocolSupport(ZooKeeper zookeeper) {
        this.zookeeper = zookeeper;
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.doClose();
        }
    }

    public ZooKeeper getZookeeper() {
        return this.zookeeper;
    }

    public List<ACL> getAcl() {
        return this.acl;
    }

    public void setAcl(List<ACL> acl) {
        this.acl = acl;
    }

    public long getRetryDelay() {
        return this.retryDelay;
    }

    public void setRetryDelay(long retryDelay) {
        this.retryDelay = retryDelay;
    }

    protected void doClose() {
    }

    protected Object retryOperation(ZooKeeperOperation operation) throws KeeperException, InterruptedException {
        KeeperException.ConnectionLossException exception = null;
        for (int i = 0; i < this.retryCount; ++i) {
            try {
                return operation.execute();
            }
            catch (KeeperException.SessionExpiredException e) {
                LOG.warn((Object)("Session expired for: " + this.zookeeper + " so reconnecting due to: " + (Object)((Object)e)), (Throwable)e);
                throw e;
            }
            catch (KeeperException.ConnectionLossException e) {
                if (exception == null) {
                    exception = e;
                }
                LOG.debug((Object)("Attempt " + i + " failed with connection loss so " + "attempting to reconnect: " + (Object)((Object)e)), (Throwable)e);
                this.retryDelay(i);
                continue;
            }
        }
        throw exception;
    }

    protected void ensurePathExists(String path) {
        this.ensureExists(path, null, this.acl, CreateMode.PERSISTENT);
    }

    protected void ensureExists(final String path, final byte[] data, final List<ACL> acl, final CreateMode flags) {
        try {
            this.retryOperation(new ZooKeeperOperation(){

                @Override
                public boolean execute() throws KeeperException, InterruptedException {
                    Stat stat = ProtocolSupport.this.zookeeper.exists(path, false);
                    if (stat != null) {
                        return true;
                    }
                    ProtocolSupport.this.zookeeper.create(path, data, acl, flags);
                    return true;
                }
            });
        }
        catch (KeeperException e) {
            LOG.warn((Object)("Caught: " + (Object)((Object)e)), (Throwable)e);
        }
        catch (InterruptedException e) {
            LOG.warn((Object)("Caught: " + e), (Throwable)e);
        }
    }

    protected boolean isClosed() {
        return this.closed.get();
    }

    protected void retryDelay(int attemptCount) {
        if (attemptCount > 0) {
            try {
                Thread.sleep((long)attemptCount * this.retryDelay);
            }
            catch (InterruptedException e) {
                LOG.debug((Object)("Failed to sleep: " + e), (Throwable)e);
            }
        }
    }
}

