/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.sqlserver.parser;

import com.alibaba.druid.sql.ast.SQLDeclareItem;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.statement.SQLBlockStatement;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLConstraint;
import com.alibaba.druid.sql.ast.statement.SQLIfStatement;
import com.alibaba.druid.sql.ast.statement.SQLInsertInto;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSetStatement;
import com.alibaba.druid.sql.ast.statement.SQLTableElement;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.dialect.sqlserver.ast.SQLServerOutput;
import com.alibaba.druid.sql.dialect.sqlserver.ast.SQLServerTop;
import com.alibaba.druid.sql.dialect.sqlserver.ast.stmt.SQLServerCommitStatement;
import com.alibaba.druid.sql.dialect.sqlserver.ast.stmt.SQLServerDeclareStatement;
import com.alibaba.druid.sql.dialect.sqlserver.ast.stmt.SQLServerExecStatement;
import com.alibaba.druid.sql.dialect.sqlserver.ast.stmt.SQLServerInsertStatement;
import com.alibaba.druid.sql.dialect.sqlserver.ast.stmt.SQLServerRollbackStatement;
import com.alibaba.druid.sql.dialect.sqlserver.ast.stmt.SQLServerSetStatement;
import com.alibaba.druid.sql.dialect.sqlserver.ast.stmt.SQLServerSetTransactionIsolationLevelStatement;
import com.alibaba.druid.sql.dialect.sqlserver.ast.stmt.SQLServerUpdateStatement;
import com.alibaba.druid.sql.dialect.sqlserver.ast.stmt.SQLServerWaitForStatement;
import com.alibaba.druid.sql.dialect.sqlserver.parser.SQLServerExprParser;
import com.alibaba.druid.sql.dialect.sqlserver.parser.SQLServerSelectParser;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLSelectParser;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.parser.Token;
import java.util.Collection;
import java.util.List;

public class SQLServerStatementParser
extends SQLStatementParser {
    public SQLServerStatementParser(String sql) {
        super(new SQLServerExprParser(sql));
    }

    @Override
    public SQLSelectParser createSQLSelectParser() {
        return new SQLServerSelectParser(this.exprParser);
    }

    public SQLServerStatementParser(Lexer lexer) {
        super(new SQLServerExprParser(lexer));
    }

    @Override
    public boolean parseStatementListDialect(List<SQLStatement> statementList) {
        if (this.lexer.token() == Token.WITH) {
            SQLSelectStatement stmt = this.parseSelect();
            statementList.add(stmt);
            return true;
        }
        if (this.identifierEquals("EXEC") || this.identifierEquals("EXECUTE")) {
            this.lexer.nextToken();
            SQLServerExecStatement execStmt = new SQLServerExecStatement();
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                this.parseExecParameter(execStmt.getParameters(), execStmt);
                this.accept(Token.RPAREN);
            } else {
                SQLName sqlNameName = this.exprParser.name();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                    execStmt.setReturnStatus(sqlNameName);
                    execStmt.setModuleName(this.exprParser.name());
                } else {
                    execStmt.setModuleName(sqlNameName);
                }
                this.parseExecParameter(execStmt.getParameters(), execStmt);
            }
            statementList.add(execStmt);
            return true;
        }
        if (this.lexer.token() == Token.DECLARE) {
            statementList.add(this.parseDeclare());
            return true;
        }
        if (this.lexer.token() == Token.IF) {
            statementList.add(this.parseIf());
            return true;
        }
        if (this.lexer.token() == Token.BEGIN) {
            statementList.add(this.parseBlock());
            return true;
        }
        if (this.lexer.token() == Token.COMMIT) {
            statementList.add(this.parseCommit());
            return true;
        }
        if (this.identifierEquals("WAITFOR")) {
            statementList.add(this.parseWaitFor());
            return true;
        }
        return false;
    }

    public void parseExecParameter(Collection<SQLServerExecStatement.SQLServerParameter> exprCol, SQLObject parent) {
        if (this.lexer.token() == Token.RPAREN || this.lexer.token() == Token.RBRACKET) {
            return;
        }
        if (this.lexer.token() == Token.EOF) {
            return;
        }
        SQLServerExecStatement.SQLServerParameter param = new SQLServerExecStatement.SQLServerParameter();
        SQLExpr expr = this.exprParser.expr();
        expr.setParent(parent);
        param.setExpr(expr);
        if (this.lexer.token() == Token.OUT) {
            param.setType(true);
            this.accept(Token.OUT);
        }
        exprCol.add(param);
        while (this.lexer.token() == Token.COMMA) {
            this.lexer.nextToken();
            param = new SQLServerExecStatement.SQLServerParameter();
            expr = this.exprParser.expr();
            expr.setParent(parent);
            param.setExpr(expr);
            if (this.lexer.token() == Token.OUT) {
                param.setType(true);
                this.accept(Token.OUT);
            }
            exprCol.add(param);
        }
    }

    public SQLStatement parseDeclare() {
        this.accept(Token.DECLARE);
        SQLServerDeclareStatement declareStatement = new SQLServerDeclareStatement();
        while (true) {
            SQLDeclareItem item = new SQLDeclareItem();
            declareStatement.addItem(item);
            item.setName(this.exprParser.name());
            if (this.lexer.token() == Token.AS) {
                this.lexer.nextToken();
            }
            if (this.lexer.token() == Token.TABLE) {
                this.lexer.nextToken();
                item.setType(SQLDeclareItem.Type.TABLE);
                if (this.lexer.token() != Token.LPAREN) break;
                this.lexer.nextToken();
                do {
                    SQLColumnDefinition column;
                    if (this.lexer.token() == Token.IDENTIFIER || this.lexer.token() == Token.LITERAL_ALIAS) {
                        column = this.exprParser.parseColumn();
                        item.getTableElementList().add(column);
                    } else if (this.lexer.token() == Token.PRIMARY || this.lexer.token() == Token.UNIQUE || this.lexer.token() == Token.CHECK || this.lexer.token() == Token.CONSTRAINT) {
                        SQLConstraint constraint = this.exprParser.parseConstaint();
                        constraint.setParent(item);
                        item.getTableElementList().add((SQLTableElement)((Object)constraint));
                    } else {
                        if (this.lexer.token() == Token.TABLESPACE) {
                            throw new ParserException("TODO " + (Object)((Object)this.lexer.token()));
                        }
                        column = this.exprParser.parseColumn();
                        item.getTableElementList().add(column);
                    }
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                } while (this.lexer.token() != Token.RPAREN);
                this.accept(Token.RPAREN);
                break;
            }
            if (this.lexer.token() == Token.CURSOR) {
                item.setType(SQLDeclareItem.Type.CURSOR);
                this.lexer.nextToken();
            } else {
                item.setType(SQLDeclareItem.Type.LOCAL);
                item.setDataType(this.exprParser.parseDataType());
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                    item.setValue(this.exprParser.expr());
                }
            }
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        return declareStatement;
    }

    @Override
    public SQLStatement parseInsert() {
        SQLServerInsertStatement insertStatement = new SQLServerInsertStatement();
        if (this.lexer.token() == Token.INSERT) {
            this.accept(Token.INSERT);
        }
        this.parseInsert0(insertStatement);
        return insertStatement;
    }

    @Override
    protected void parseInsert0(SQLInsertInto insert, boolean acceptSubQuery) {
        SQLServerOutput output;
        SQLServerInsertStatement insertStatement = (SQLServerInsertStatement)insert;
        SQLServerTop top = this.getExprParser().parseTop();
        if (top != null) {
            insertStatement.setTop(top);
        }
        if (this.lexer.token() == Token.INTO) {
            this.lexer.nextToken();
        }
        SQLName tableName = this.exprParser.name();
        insertStatement.setTableName(tableName);
        if (this.lexer.token() == Token.LITERAL_ALIAS) {
            insertStatement.setAlias(this.as());
        }
        this.parseInsert0_hinits(insertStatement);
        if (this.lexer.token() == Token.IDENTIFIER && !this.lexer.stringVal().equalsIgnoreCase("OUTPUT")) {
            insertStatement.setAlias(this.lexer.stringVal());
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            this.exprParser.exprList(insertStatement.getColumns(), insertStatement);
            this.accept(Token.RPAREN);
        }
        if ((output = this.getExprParser().parserOutput()) != null) {
            insertStatement.setOutput(output);
        }
        if (this.lexer.token() == Token.VALUES) {
            this.lexer.nextToken();
            while (true) {
                this.accept(Token.LPAREN);
                SQLInsertStatement.ValuesClause values = new SQLInsertStatement.ValuesClause();
                this.exprParser.exprList(values.getValues(), values);
                insertStatement.getValuesList().add(values);
                this.accept(Token.RPAREN);
                if (!this.parseCompleteValues && insertStatement.getValuesList().size() >= this.parseValuesSize) {
                    this.lexer.skipToEOF();
                } else if (this.lexer.token() == Token.COMMA) {
                    this.lexer.nextToken();
                    continue;
                }
                break;
            }
        } else if (acceptSubQuery && (this.lexer.token() == Token.SELECT || this.lexer.token() == Token.LPAREN)) {
            SQLQueryExpr queryExpr = (SQLQueryExpr)this.exprParser.expr();
            insertStatement.setQuery(queryExpr.getSubQuery());
        } else if (this.lexer.token() == Token.DEFAULT) {
            this.lexer.nextToken();
            this.accept(Token.VALUES);
            insertStatement.setDefaultValues(true);
        }
    }

    @Override
    protected SQLServerUpdateStatement createUpdateStatement() {
        return new SQLServerUpdateStatement();
    }

    @Override
    public SQLUpdateStatement parseUpdateStatement() {
        SQLServerUpdateStatement udpateStatement = this.createUpdateStatement();
        this.accept(Token.UPDATE);
        SQLServerTop top = this.getExprParser().parseTop();
        if (top != null) {
            udpateStatement.setTop(top);
        }
        SQLTableSource tableSource = this.exprParser.createSelectParser().parseTableSource();
        udpateStatement.setTableSource(tableSource);
        this.parseUpdateSet(udpateStatement);
        SQLServerOutput output = this.getExprParser().parserOutput();
        if (output != null) {
            udpateStatement.setOutput(output);
        }
        if (this.lexer.token() == Token.FROM) {
            this.lexer.nextToken();
            SQLTableSource from = this.exprParser.createSelectParser().parseTableSource();
            udpateStatement.setFrom(from);
        }
        if (this.lexer.token() == Token.WHERE) {
            this.lexer.nextToken();
            udpateStatement.setWhere(this.exprParser.expr());
        }
        return udpateStatement;
    }

    @Override
    public SQLServerExprParser getExprParser() {
        return (SQLServerExprParser)this.exprParser;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public SQLStatement parseSet() {
        this.accept(Token.SET);
        if (this.identifierEquals("TRANSACTION")) {
            this.lexer.nextToken();
            this.acceptIdentifier("ISOLATION");
            this.acceptIdentifier("LEVEL");
            SQLServerSetTransactionIsolationLevelStatement stmt = new SQLServerSetTransactionIsolationLevelStatement();
            if (this.identifierEquals("READ")) {
                this.lexer.nextToken();
                if (this.identifierEquals("UNCOMMITTED")) {
                    stmt.setLevel("READ UNCOMMITTED");
                    this.lexer.nextToken();
                    return stmt;
                } else {
                    if (!this.identifierEquals("COMMITTED")) throw new ParserException("UNKOWN TRANSACTION LEVEL : " + this.lexer.stringVal());
                    stmt.setLevel("READ COMMITTED");
                    this.lexer.nextToken();
                }
                return stmt;
            } else if (this.identifierEquals("SERIALIZABLE")) {
                stmt.setLevel("SERIALIZABLE");
                this.lexer.nextToken();
                return stmt;
            } else if (this.identifierEquals("SNAPSHOT")) {
                stmt.setLevel("SNAPSHOT");
                this.lexer.nextToken();
                return stmt;
            } else {
                if (!this.identifierEquals("REPEATABLE")) throw new ParserException("UNKOWN TRANSACTION LEVEL : " + this.lexer.stringVal());
                this.lexer.nextToken();
                if (!this.identifierEquals("READ")) throw new ParserException("UNKOWN TRANSACTION LEVEL : " + this.lexer.stringVal());
                stmt.setLevel("REPEATABLE READ");
                this.lexer.nextToken();
            }
            return stmt;
        }
        if (this.identifierEquals("STATISTICS")) {
            this.lexer.nextToken();
            SQLServerSetStatement stmt = new SQLServerSetStatement();
            if (!this.identifierEquals("IO") && !this.identifierEquals("XML") && !this.identifierEquals("PROFILE") && !this.identifierEquals("TIME")) return stmt;
            stmt.getItem().setTarget(new SQLIdentifierExpr("STATISTICS " + this.lexer.stringVal().toUpperCase()));
            this.lexer.nextToken();
            if (this.lexer.token() == Token.ON) {
                stmt.getItem().setValue(new SQLIdentifierExpr("ON"));
                this.lexer.nextToken();
                return stmt;
            } else {
                if (!this.identifierEquals("OFF")) return stmt;
                stmt.getItem().setValue(new SQLIdentifierExpr("OFF"));
                this.lexer.nextToken();
            }
            return stmt;
        }
        if (this.lexer.token() == Token.VARIANT) {
            SQLSetStatement stmt = new SQLSetStatement(this.getDbType());
            this.parseAssignItems(stmt.getItems(), stmt);
            return stmt;
        }
        SQLServerSetStatement stmt = new SQLServerSetStatement();
        stmt.getItem().setTarget(this.exprParser.expr());
        if (this.lexer.token() == Token.ON) {
            stmt.getItem().setValue(new SQLIdentifierExpr("ON"));
            this.lexer.nextToken();
            return stmt;
        } else if (this.identifierEquals("OFF")) {
            stmt.getItem().setValue(new SQLIdentifierExpr("OFF"));
            this.lexer.nextToken();
            return stmt;
        } else {
            stmt.getItem().setValue(this.exprParser.expr());
        }
        return stmt;
    }

    public SQLIfStatement parseIf() {
        this.accept(Token.IF);
        SQLIfStatement stmt = new SQLIfStatement();
        stmt.setCondition(this.exprParser.expr());
        this.parseStatementList(stmt.getStatements(), 1);
        if (this.lexer.token() == Token.SEMI) {
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.ELSE) {
            this.lexer.nextToken();
            SQLIfStatement.Else elseItem = new SQLIfStatement.Else();
            this.parseStatementList(elseItem.getStatements(), 1);
            stmt.setElseItem(elseItem);
        }
        return stmt;
    }

    @Override
    public SQLBlockStatement parseBlock() {
        SQLBlockStatement block = new SQLBlockStatement();
        this.accept(Token.BEGIN);
        this.parseStatementList(block.getStatementList());
        this.accept(Token.END);
        return block;
    }

    @Override
    public SQLServerCommitStatement parseCommit() {
        this.acceptIdentifier("COMMIT");
        SQLServerCommitStatement stmt = new SQLServerCommitStatement();
        if (this.identifierEquals("WORK")) {
            this.lexer.nextToken();
            stmt.setWork(true);
        }
        if (this.identifierEquals("TRAN") || this.identifierEquals("TRANSACTION")) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.IDENTIFIER || this.lexer.token() == Token.VARIANT) {
                stmt.setTransactionName(this.exprParser.expr());
            }
            if (this.lexer.token() == Token.WITH) {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                this.acceptIdentifier("DELAYED_DURABILITY");
                this.accept(Token.EQ);
                stmt.setDelayedDurability(this.exprParser.expr());
                this.accept(Token.RPAREN);
            }
        }
        return stmt;
    }

    @Override
    public SQLServerRollbackStatement parseRollback() {
        this.acceptIdentifier("ROLLBACK");
        SQLServerRollbackStatement stmt = new SQLServerRollbackStatement();
        if (this.identifierEquals("WORK")) {
            this.lexer.nextToken();
            stmt.setWork(true);
        }
        if (this.identifierEquals("TRAN") || this.identifierEquals("TRANSACTION")) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.IDENTIFIER || this.lexer.token() == Token.VARIANT) {
                stmt.setName(this.exprParser.expr());
            }
        }
        return stmt;
    }

    public SQLServerWaitForStatement parseWaitFor() {
        this.acceptIdentifier("WAITFOR");
        SQLServerWaitForStatement stmt = new SQLServerWaitForStatement();
        if (this.identifierEquals("DELAY")) {
            this.lexer.nextToken();
            stmt.setDelay(this.exprParser.expr());
        }
        if (this.identifierEquals("TIME")) {
            this.lexer.nextToken();
            stmt.setTime(this.exprParser.expr());
        }
        if (this.lexer.token() == Token.COMMA) {
            this.lexer.nextToken();
            if (this.identifierEquals("TIMEOUT")) {
                this.lexer.nextToken();
                stmt.setTimeout(this.exprParser.expr());
            }
        }
        return stmt;
    }
}

