/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.comet.CometEvent;
import org.apache.catalina.comet.CometProcessor;
import org.apache.catalina.connector.ClientAbortException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.ApplicationFilterChain;
import org.apache.catalina.core.ApplicationFilterFactory;
import org.apache.catalina.core.AsyncContextImpl;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.valves.ValveBase;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.log.SystemLogHandler;
import org.apache.tomcat.util.res.StringManager;

final class StandardWrapperValve
extends ValveBase {
    private volatile long processingTime;
    private volatile long maxTime;
    private volatile long minTime = Long.MAX_VALUE;
    private final AtomicInteger requestCount = new AtomicInteger(0);
    private final AtomicInteger errorCount = new AtomicInteger(0);
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");

    public StandardWrapperValve() {
        super(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void invoke(Request request, Response response) throws IOException, ServletException {
        long t1;
        block51: {
            Servlet servlet;
            StandardWrapper wrapper;
            Throwable throwable;
            block50: {
                ApplicationFilterChain filterChain;
                block49: {
                    boolean unavailable = false;
                    throwable = null;
                    t1 = System.currentTimeMillis();
                    this.requestCount.incrementAndGet();
                    wrapper = (StandardWrapper)this.getContainer();
                    servlet = null;
                    Context context = (Context)wrapper.getParent();
                    if (!context.getState().isAvailable()) {
                        response.sendError(503, sm.getString("standardContext.isUnavailable"));
                        unavailable = true;
                    }
                    if (!unavailable && wrapper.isUnavailable()) {
                        this.container.getLogger().info((Object)sm.getString("standardWrapper.isUnavailable", wrapper.getName()));
                        long available = wrapper.getAvailable();
                        if (available > 0L && available < Long.MAX_VALUE) {
                            response.setDateHeader("Retry-After", available);
                            response.sendError(503, sm.getString("standardWrapper.isUnavailable", wrapper.getName()));
                        } else if (available == Long.MAX_VALUE) {
                            response.sendError(404, sm.getString("standardWrapper.notFound", wrapper.getName()));
                        }
                        unavailable = true;
                    }
                    try {
                        if (!unavailable) {
                            servlet = wrapper.allocate();
                        }
                    }
                    catch (UnavailableException e) {
                        this.container.getLogger().error((Object)sm.getString("standardWrapper.allocateException", wrapper.getName()), (Throwable)e);
                        long available = wrapper.getAvailable();
                        if (available > 0L && available < Long.MAX_VALUE) {
                            response.setDateHeader("Retry-After", available);
                            response.sendError(503, sm.getString("standardWrapper.isUnavailable", wrapper.getName()));
                        } else if (available == Long.MAX_VALUE) {
                            response.sendError(404, sm.getString("standardWrapper.notFound", wrapper.getName()));
                        }
                    }
                    catch (ServletException e) {
                        this.container.getLogger().error((Object)sm.getString("standardWrapper.allocateException", wrapper.getName()), StandardWrapper.getRootCause(e));
                        throwable = e;
                        this.exception(request, response, e);
                    }
                    catch (Throwable e) {
                        ExceptionUtils.handleThrowable(e);
                        this.container.getLogger().error((Object)sm.getString("standardWrapper.allocateException", wrapper.getName()), e);
                        throwable = e;
                        this.exception(request, response, e);
                        servlet = null;
                    }
                    boolean comet = false;
                    if (servlet instanceof CometProcessor && request.getAttribute("org.apache.tomcat.comet.support") == Boolean.TRUE) {
                        comet = true;
                        request.setComet(true);
                    }
                    MessageBytes requestPathMB = request.getRequestPathMB();
                    DispatcherType dispatcherType = DispatcherType.REQUEST;
                    if (request.getDispatcherType() == DispatcherType.ASYNC) {
                        dispatcherType = DispatcherType.ASYNC;
                    }
                    request.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", (Object)dispatcherType);
                    request.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", requestPathMB);
                    ApplicationFilterFactory factory = ApplicationFilterFactory.getInstance();
                    filterChain = factory.createFilterChain(request, wrapper, servlet);
                    request.setComet(false);
                    try {
                        if (servlet == null || filterChain == null) break block49;
                        if (context.getSwallowOutput()) {
                            try {
                                SystemLogHandler.startCapture();
                                if (request.isAsyncDispatching()) {
                                    ((AsyncContextImpl)request.getAsyncContext()).doInternalDispatch();
                                } else if (comet) {
                                    filterChain.doFilterEvent(request.getEvent());
                                    request.setComet(true);
                                } else {
                                    filterChain.doFilter(request.getRequest(), response.getResponse());
                                }
                                break block49;
                            }
                            finally {
                                String log = SystemLogHandler.stopCapture();
                                if (log != null && log.length() > 0) {
                                    context.getLogger().info((Object)log);
                                }
                            }
                        }
                        if (request.isAsyncDispatching()) {
                            ((AsyncContextImpl)request.getAsyncContext()).doInternalDispatch();
                        } else if (comet) {
                            request.setComet(true);
                            filterChain.doFilterEvent(request.getEvent());
                        } else {
                            filterChain.doFilter(request.getRequest(), response.getResponse());
                        }
                    }
                    catch (ClientAbortException e) {
                        throwable = e;
                        this.exception(request, response, e);
                    }
                    catch (IOException e) {
                        this.container.getLogger().error((Object)sm.getString("standardWrapper.serviceException", wrapper.getName(), context.getName()), (Throwable)e);
                        throwable = e;
                        this.exception(request, response, e);
                    }
                    catch (UnavailableException e) {
                        this.container.getLogger().error((Object)sm.getString("standardWrapper.serviceException", wrapper.getName(), context.getName()), (Throwable)e);
                        wrapper.unavailable(e);
                        long available = wrapper.getAvailable();
                        if (available > 0L && available < Long.MAX_VALUE) {
                            response.setDateHeader("Retry-After", available);
                            response.sendError(503, sm.getString("standardWrapper.isUnavailable", wrapper.getName()));
                        } else if (available == Long.MAX_VALUE) {
                            response.sendError(404, sm.getString("standardWrapper.notFound", wrapper.getName()));
                        }
                    }
                    catch (ServletException e) {
                        Throwable rootCause = StandardWrapper.getRootCause(e);
                        if (!(rootCause instanceof ClientAbortException)) {
                            this.container.getLogger().error((Object)sm.getString("standardWrapper.serviceExceptionRoot", wrapper.getName(), context.getName(), e.getMessage()), rootCause);
                        }
                        throwable = e;
                        this.exception(request, response, e);
                    }
                    catch (Throwable e) {
                        ExceptionUtils.handleThrowable(e);
                        this.container.getLogger().error((Object)sm.getString("standardWrapper.serviceException", wrapper.getName(), context.getName()), e);
                        throwable = e;
                        this.exception(request, response, e);
                    }
                }
                if (filterChain != null) {
                    if (request.isComet()) {
                        filterChain.reuse();
                    } else {
                        filterChain.release();
                    }
                }
                try {
                    if (servlet != null) {
                        wrapper.deallocate(servlet);
                    }
                }
                catch (Throwable e) {
                    ExceptionUtils.handleThrowable(e);
                    this.container.getLogger().error((Object)sm.getString("standardWrapper.deallocateException", wrapper.getName()), e);
                    if (throwable != null) break block50;
                    throwable = e;
                    this.exception(request, response, e);
                }
            }
            try {
                if (servlet != null && wrapper.getAvailable() == Long.MAX_VALUE) {
                    wrapper.unload();
                }
            }
            catch (Throwable e) {
                ExceptionUtils.handleThrowable(e);
                this.container.getLogger().error((Object)sm.getString("standardWrapper.unloadException", wrapper.getName()), e);
                if (throwable != null) break block51;
                throwable = e;
                this.exception(request, response, e);
            }
        }
        long t2 = System.currentTimeMillis();
        long time = t2 - t1;
        this.processingTime += time;
        if (time > this.maxTime) {
            this.maxTime = time;
        }
        if (time < this.minTime) {
            this.minTime = time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void event(Request request, Response response, CometEvent event) throws IOException, ServletException {
        long t1;
        block29: {
            Servlet servlet;
            StandardWrapper wrapper;
            Throwable throwable;
            block28: {
                ApplicationFilterChain filterChain;
                block27: {
                    throwable = null;
                    t1 = System.currentTimeMillis();
                    wrapper = (StandardWrapper)this.getContainer();
                    if (wrapper == null) {
                        return;
                    }
                    servlet = null;
                    Context context = (Context)wrapper.getParent();
                    boolean unavailable = !context.getState().isAvailable() || wrapper.isUnavailable();
                    try {
                        if (!unavailable) {
                            servlet = wrapper.allocate();
                        }
                    }
                    catch (UnavailableException unavailableException) {
                    }
                    catch (ServletException e) {
                        this.container.getLogger().error((Object)sm.getString("standardWrapper.allocateException", wrapper.getName()), StandardWrapper.getRootCause(e));
                        throwable = e;
                        this.exception(request, response, e);
                    }
                    catch (Throwable e) {
                        ExceptionUtils.handleThrowable(e);
                        this.container.getLogger().error((Object)sm.getString("standardWrapper.allocateException", wrapper.getName()), e);
                        throwable = e;
                        this.exception(request, response, e);
                        servlet = null;
                    }
                    MessageBytes requestPathMB = request.getRequestPathMB();
                    request.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", (Object)DispatcherType.REQUEST);
                    request.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", requestPathMB);
                    filterChain = (ApplicationFilterChain)request.getFilterChain();
                    try {
                        if (servlet == null || filterChain == null) break block27;
                        if (context.getSwallowOutput()) {
                            try {
                                SystemLogHandler.startCapture();
                                filterChain.doFilterEvent(request.getEvent());
                                break block27;
                            }
                            finally {
                                String log = SystemLogHandler.stopCapture();
                                if (log != null && log.length() > 0) {
                                    context.getLogger().info((Object)log);
                                }
                            }
                        }
                        filterChain.doFilterEvent(request.getEvent());
                    }
                    catch (ClientAbortException e) {
                        throwable = e;
                        this.exception(request, response, e);
                    }
                    catch (IOException e) {
                        this.container.getLogger().error((Object)sm.getString("standardWrapper.serviceException", wrapper.getName(), context.getName()), (Throwable)e);
                        throwable = e;
                        this.exception(request, response, e);
                    }
                    catch (UnavailableException e) {
                        this.container.getLogger().error((Object)sm.getString("standardWrapper.serviceException", wrapper.getName(), context.getName()), (Throwable)e);
                    }
                    catch (ServletException e) {
                        Throwable rootCause = StandardWrapper.getRootCause(e);
                        if (!(rootCause instanceof ClientAbortException)) {
                            this.container.getLogger().error((Object)sm.getString("standardWrapper.serviceExceptionRoot", wrapper.getName(), context.getName(), e.getMessage()), rootCause);
                        }
                        throwable = e;
                        this.exception(request, response, e);
                    }
                    catch (Throwable e) {
                        ExceptionUtils.handleThrowable(e);
                        this.container.getLogger().error((Object)sm.getString("standardWrapper.serviceException", wrapper.getName(), context.getName()), e);
                        throwable = e;
                        this.exception(request, response, e);
                    }
                }
                if (filterChain != null) {
                    filterChain.reuse();
                }
                try {
                    if (servlet != null) {
                        wrapper.deallocate(servlet);
                    }
                }
                catch (Throwable e) {
                    ExceptionUtils.handleThrowable(e);
                    this.container.getLogger().error((Object)sm.getString("standardWrapper.deallocateException", wrapper.getName()), e);
                    if (throwable != null) break block28;
                    throwable = e;
                    this.exception(request, response, e);
                }
            }
            try {
                if (servlet != null && wrapper.getAvailable() == Long.MAX_VALUE) {
                    wrapper.unload();
                }
            }
            catch (Throwable e) {
                ExceptionUtils.handleThrowable(e);
                this.container.getLogger().error((Object)sm.getString("standardWrapper.unloadException", wrapper.getName()), e);
                if (throwable != null) break block29;
                throwable = e;
                this.exception(request, response, e);
            }
        }
        long t2 = System.currentTimeMillis();
        long time = t2 - t1;
        this.processingTime += time;
        if (time > this.maxTime) {
            this.maxTime = time;
        }
        if (time < this.minTime) {
            this.minTime = time;
        }
    }

    private void exception(Request request, Response response, Throwable exception) {
        request.setAttribute("javax.servlet.error.exception", exception);
        response.setStatus(500);
        response.setError();
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    public long getMaxTime() {
        return this.maxTime;
    }

    public long getMinTime() {
        return this.minTime;
    }

    public int getRequestCount() {
        return this.requestCount.get();
    }

    public int getErrorCount() {
        return this.errorCount.get();
    }

    public void incrementErrorCount() {
        this.errorCount.incrementAndGet();
    }

    @Override
    protected void initInternal() throws LifecycleException {
    }
}

