package cn.com.duiba.idmaker.service.api.enums;

/**
 * Created by xuezhaoming on 16/5/18.
 */
public enum IDMakerTypeEnums {

    STOCK(1, "库存"),

    GOODS(2, "商品"),

    COUPON(3, "优惠券")

    ;

    public static final int MAX_BIZ_VALUE = 63;

    private int             type;

    private String          desc;

    IDMakerTypeEnums(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public int getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static IDMakerTypeEnums getByType(int bizId) {

        IDMakerTypeEnums[] values = IDMakerTypeEnums.values();
        for (IDMakerTypeEnums value : values) {
            if (value.getType() == bizId) {
                return value;
            }
        }
        return null;
    }

    /**
     * 是否有效的数值
     * 
     * @param bizType 最大位63
     * @return true :有效，false :无效
     */
    public static boolean isValid(int bizType) {
        return bizType <= MAX_BIZ_VALUE;
    }
}
