package cn.com.duiba.idmaker.service.api.remoteservice;

import java.util.List;

import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by xuezhaoming on 16/5/18.
 */
public interface RemoteIDMakerService {

    /**
     * 根据业务ID，生成全局唯一的ID
     * 
     * @param bizID 业务类型 详细可见 IDMakerTypeEnums
     * @return 全局唯一ID
     */
    DubboResult<Long> getNextID(int bizID);

    /**
     * 批量获取ID,适用于少批量的接口获取
     * 
     * @param bizID 业务ID 详细可见 IDMakerTypeEnums
     * @param bacthSize 批量数 最大允许4000
     * @return 返回的唯一ID集合
     */
    DubboResult<List<Long>> getBatchNextID(int bizID, int bacthSize);

}
