package cn.com.duiba.id.idmaker.service.biz;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

import javax.annotation.Resource;

import org.springframework.stereotype.Component;

import cn.com.duiba.id.idmaker.service.biz.support.IDMakerConstants;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;

/**
 * Created by xuezhaoming on 16/5/18.<br/>
 * 业务ID生成器管理类
 */
@Component
public class IDManager {

    @Resource
    private IDMakerConstants         idMakerConstants;

    // 业务类型的缓存
    private Cache<Integer, IDWorker> bizIDCache = CacheBuilder.newBuilder().expireAfterAccess(12, TimeUnit.HOURS).concurrencyLevel(Runtime.getRuntime().availableProcessors() + 1).build();

    /**
     * 根据业务ID 生成ID
     * 
     * @param bizId 业务ID ,详细可见 IDMakerTypeEnums
     * @return 唯一ID
     * @throws ExecutionException
     */
    public long getNextId(final int bizId) throws ExecutionException {

        IDWorker idWorker = getIdWorker(bizId);

        return idWorker.nextId();

    }

    private IDWorker getIdWorker(final Integer bizID) throws ExecutionException {
        return bizIDCache.get(bizID, new Callable<IDWorker>() {

            @Override
            public IDWorker call() throws Exception {
                return new IDWorker(IDMakerConstants.machineId, bizID);
            }
        });
    }

    public long getCacheSize() {
        return bizIDCache.size();
    }

    public long cleanCache() {
        long cacheSize = bizIDCache.size();
        bizIDCache.invalidateAll();
        return cacheSize;
    }
}
