package cn.com.duiba.id.idmaker.service.biz;

/**
 * Created by xuezhaoming on 16/5/18.
 */
public class IDWorker {

    private final long        machineId;

    private final long        bizId;

    private final static long twepoch          = 1463485770L;                                                 // 2016.5.17的当前秒数
    private long              sequence         = 0L;

    public static final long  SEQUENCE_BITS    = 12L;                                                         // 自增序列
    public static final long  SEQUENCE_MASK    = -1L ^ -1L << SEQUENCE_BITS;

    private static final long MACHINE_ID_BITS  = 3L;
    private static final long MAX_MACHINE_ID   = -1L ^ -1L << MACHINE_ID_BITS;                                // 节点ID，最大8个节点
    private static final long MACHINE_OFFSET   = -1L ^ -1L << SEQUENCE_BITS;

    private static final long BIZ_ID_BITS      = 5L;
    private static final long MAX_BIZ_ID       = -1L ^ -1L << BIZ_ID_BITS;                                    // 业务ID最大32个业务
    private static final long BIZ_OFFSET       = -1L ^ -1L << (MACHINE_ID_BITS + SEQUENCE_BITS);

    private static final long TIMESTAMP_OFFSET = -1L ^ -1L << (BIZ_ID_BITS + MACHINE_ID_BITS + SEQUENCE_BITS); //

    private long              lastTimestamp    = -1L;

    // private long blankValue = BLANK_VALUE;

    // private static final int MAX_LENGTH = 64;

    /**
     * @param machineId 机器ID
     * @param bizId 业务ID
     */
    public IDWorker(final long machineId, final long bizId) {
        if (machineId > MAX_MACHINE_ID || machineId < 0) {
            throw new IllegalArgumentException(String.format("machine Id can't be greater than %d or less than 0",
                                                             MAX_MACHINE_ID));
        }
        this.machineId = machineId;

        if (bizId > MAX_BIZ_ID || bizId < 0) {
            throw new IllegalArgumentException(String.format("biz Id can't be greater than %d or less than 0",
                                                             MAX_BIZ_ID));
        }
        this.bizId = bizId;
    }

    /**
     * 时间 ＋ biz ID + 机器ID ＋ seq + blankValue
     * 
     * @return
     */
    public synchronized long nextId() {

        long timestamp = this.timeGen();
        if (this.lastTimestamp == timestamp) {
            this.sequence = (this.sequence + 1) & this.SEQUENCE_MASK;
            if (this.sequence == 0) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0;
        }

        if (timestamp < this.lastTimestamp) {
            throw new IllegalStateException(
                                            String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds",
                                                          this.lastTimestamp - timestamp));
        }
        this.lastTimestamp = timestamp;
        return (timestamp - twepoch) * TIMESTAMP_OFFSET + bizId * BIZ_OFFSET + machineId * MACHINE_OFFSET + sequence;

    }

    private long tilNextMillis(final long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    private long timeGen() {
        return System.currentTimeMillis() / 1000;
    }

    public static void main(String[] args) {

        IDWorker idWorker = new IDWorker(2, 2);
        long l = idWorker.nextId();
        System.out.println(l);
        System.out.println(String.valueOf(l).length());
        System.out.println(Long.MAX_VALUE);
        System.out.println(String.valueOf(Long.MAX_VALUE).length());

        int num = 60;
        long id = 10;
        long i = id << num;
        System.out.println(1 << 12);
        // System.out.println(i);
        System.out.println(i >>> num);

        System.out.println(100000 / 24);
    }
}
