package cn.com.duiba.id.idmaker.service.biz.remoteservice.impl;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import cn.com.duiba.id.idmaker.service.biz.IDManager;
import cn.com.duiba.id.idmaker.service.biz.support.BizCodeChecker;
import cn.com.duiba.idmaker.service.api.remoteservice.RemoteIDMakerService;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by xuezhaoming on 16/5/18.
 */
@Service
public class RemoteIDMakerServiceImpl implements RemoteIDMakerService {

    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteIDMakerServiceImpl.class);

    @Resource
    private IDManager           idManager;

    @Resource
    private BizCodeChecker      bizCodeChecker;

    @Override
    public DubboResult<Long> getNextID(int bizID) {
        if (bizID <= 0 || !bizCodeChecker.isAllow(bizID)) {
            return DubboResult.failResult("bizID is invalid  :" + bizID);
        }

        long nextId;
        try {
            nextId = idManager.getNextId(bizID);
        } catch (Exception e) {
            LOGGER.error("get next ID error ,biz ID {}", new Object[] { String.valueOf(bizID) });
            return DubboResult.failResult("getNextID failed :" + e.getMessage());
        }

        return DubboResult.successResult(nextId);
    }

    @Override
    public DubboResult<List<Long>> getNextID(int bizID, int bacthSize) {
        if (bizID <= 0 || !bizCodeChecker.isAllow(bizID)) {
            return DubboResult.failResult("bizID is invalid  :" + bizID);
        }

        List<Long> ids = null;
        try {
            ids = new ArrayList<Long>(bacthSize);

            for (int i = 0; i < bacthSize; i++) {
                DubboResult<Long> tempDubboResult = getNextID(bizID);

                if (!tempDubboResult.isSuccess()) {
                    return DubboResult.failResult("get batch error : " + tempDubboResult.getMsg());
                }

                ids.add(tempDubboResult.getResult());
            }
        } catch (Exception e) {
            LOGGER.error("get next ID batch  error ,biz ID {} batch Size {} ", new Object[] { String.valueOf(bizID),
                    String.valueOf(bacthSize) });
            return DubboResult.failResult(e.getMessage());
        }

        return DubboResult.successResult(ids);
    }
}
