package cn.com.duiba.id.idmaker.service.biz.support;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import com.google.common.base.Splitter;

/**
 * Created by xuezhaoming on 16/5/19.
 */
@Component
public final class BizCodeChecker {

    private static final Logger LOGGER = LoggerFactory.getLogger(BizCodeChecker.class);

    @Resource
    private IDMakerConstants idMakerConstants;

    private volatile List<Integer> allowBizs;

    public boolean isAllow(int bizId) {


        initAllowBizs();

        return allowBizs.contains(bizId);

    }

    private void initAllowBizs() {

        if (CollectionUtils.isEmpty(allowBizs)) {


            synchronized (this) {
                if (CollectionUtils.isEmpty(allowBizs)) {

                    String allowBiz = idMakerConstants.getAllowBiz();

                    LOGGER.info("allowBiz {}", new Object[]{allowBiz});

                    allowBizs = new ArrayList<>();

                    Iterable<String> split = Splitter.on(",").omitEmptyStrings().trimResults().split(allowBiz);

                    for (String s : split) {
                        allowBizs.add(Integer.valueOf(s));
                    }
                }
            }
        }
    }
}
