package cn.com.duiba.id.idmaker.service.biz.support;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/**
 * Created by xuezhaoming on 16/5/18.
 */

@Component
public class IDMakerConstants {

    private static final Logger LOGGER            = LoggerFactory.getLogger(IDMakerConstants.class);

    private static final String MACHINE_ID_CONFIG = "idmaker.machine.id";

    public static final String  DEFAULE_ID        = "2";

    static {
        String machineIdARGS = System.getProperty(MACHINE_ID_CONFIG);

        if (StringUtils.isBlank(machineIdARGS)) {
            LOGGER.warn("idmaker.machine.id is null {} use default value {}",
                        new Object[] { machineIdARGS, DEFAULE_ID });
            machineIdARGS = DEFAULE_ID;
        }

        machineId = Integer.valueOf(machineIdARGS);

        LOGGER.info("machineID {} ", new Object[] { machineIdARGS });

    }
    public static int           machineId;

    @Value("${idmaker.allow.bizid}")
    private String              allowBiz;

    public String getAllowBiz() {
        return allowBiz;
    }

    public void setAllowBiz(String allowBiz) {
        this.allowBiz = allowBiz;
    }
}
