/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.id.idmaker.service.biz;

import cn.com.duiba.id.idmaker.service.biz.IDWorker;
import cn.com.duiba.id.idmaker.service.biz.support.IDMakerConstants;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class IDManager {
    @Resource
    private IDMakerConstants idMakerConstants;
    private Cache<Integer, IDWorker> bizIDCache = CacheBuilder.newBuilder().expireAfterAccess(12L, TimeUnit.HOURS).concurrencyLevel(Runtime.getRuntime().availableProcessors() + 1).build();

    public long getNextId(int bizId) throws ExecutionException {
        IDWorker idWorker = this.getIdWorker(bizId);
        return idWorker.nextId();
    }

    private IDWorker getIdWorker(final Integer bizID) throws ExecutionException {
        return (IDWorker)this.bizIDCache.get((Object)bizID, (Callable)new Callable<IDWorker>(){

            @Override
            public IDWorker call() throws Exception {
                return new IDWorker(IDMakerConstants.machineId, bizID.intValue());
            }
        });
    }

    public long getCacheSize() {
        return this.bizIDCache.size();
    }

    public long cleanCache() {
        long cacheSize = this.bizIDCache.size();
        this.bizIDCache.invalidateAll();
        return cacheSize;
    }
}

