/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.id.idmaker.service.biz.remoteservice.impl;

import cn.com.duiba.id.idmaker.service.biz.IDManager;
import cn.com.duiba.id.idmaker.service.biz.support.BizCodeChecker;
import cn.com.duiba.idmaker.service.api.remoteservice.RemoteIDMakerService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RemoteIDMakerServiceImpl
implements RemoteIDMakerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteIDMakerServiceImpl.class);
    @Resource
    private IDManager idManager;
    @Resource
    private BizCodeChecker bizCodeChecker;

    public DubboResult<Long> getNextID(int bizID) {
        long nextId;
        if (bizID <= 0 || !this.bizCodeChecker.isAllow(bizID)) {
            return DubboResult.failResult((String)("bizID is invalid  :" + bizID));
        }
        try {
            nextId = this.idManager.getNextId(bizID);
        }
        catch (Exception e) {
            LOGGER.error("get next ID error ,biz ID {}", new Object[]{String.valueOf(bizID)});
            return DubboResult.failResult((String)("getNextID failed :" + e.getMessage()));
        }
        return DubboResult.successResult((Object)nextId);
    }

    public DubboResult<List<Long>> getNextID(int bizID, int bacthSize) {
        if (bizID <= 0 || !this.bizCodeChecker.isAllow(bizID)) {
            return DubboResult.failResult((String)("bizID is invalid  :" + bizID));
        }
        ArrayList<Object> ids = null;
        try {
            ids = new ArrayList<Object>(bacthSize);
            for (int i = 0; i < bacthSize; ++i) {
                DubboResult<Long> tempDubboResult = this.getNextID(bizID);
                if (!tempDubboResult.isSuccess()) {
                    return DubboResult.failResult((String)("get batch error : " + tempDubboResult.getMsg()));
                }
                ids.add(tempDubboResult.getResult());
            }
        }
        catch (Exception e) {
            LOGGER.error("get next ID batch  error ,biz ID {} batch Size {} ", new Object[]{String.valueOf(bizID), String.valueOf(bacthSize)});
            return DubboResult.failResult((String)e.getMessage());
        }
        return DubboResult.successResult(ids);
    }
}

