/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.id.idmaker.service.biz.support;

import cn.com.duiba.id.idmaker.service.biz.support.IDMakerConstants;
import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public final class BizCodeChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(BizCodeChecker.class);
    @Resource
    private IDMakerConstants idMakerConstants;
    private volatile List<Integer> allowBizs;

    public boolean isAllow(int bizId) {
        this.initAllowBizs();
        return this.allowBizs.contains(bizId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAllowBizs() {
        if (CollectionUtils.isEmpty(this.allowBizs)) {
            BizCodeChecker bizCodeChecker = this;
            synchronized (bizCodeChecker) {
                if (CollectionUtils.isEmpty(this.allowBizs)) {
                    String allowBiz = this.idMakerConstants.getAllowBiz();
                    LOGGER.info("allowBiz {}", new Object[]{allowBiz});
                    this.allowBizs = new ArrayList<Integer>();
                    Iterable split = Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)allowBiz);
                    for (String s : split) {
                        this.allowBizs.add(Integer.valueOf(s));
                    }
                }
            }
        }
    }
}

