/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.id.idmaker.service.biz.remoteservice.impl;

import cn.com.duiba.id.idmaker.service.biz.service.IDMakerService;
import cn.com.duiba.id.idmaker.service.biz.support.ErrorCode;
import cn.com.duiba.idmaker.service.api.remoteservice.RemoteIDMakerBackendService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.log.DBLogger;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RemoteIDMakerBackendServiceImpl
implements RemoteIDMakerBackendService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteIDMakerBackendServiceImpl.class);
    private static final DBLogger DB_LOGGER = DBLogger.builder().aClass(RemoteIDMakerBackendServiceImpl.class).build();
    private static final String DEFAULT_BIZNO = "default_bizNo";
    @Resource
    private IDMakerService idMakerService;

    public DubboResult<Long> getBatchNextID(String bizID, long bacthSize) {
        if (bacthSize <= 0L) {
            DB_LOGGER.error(ErrorCode.IS_0201001.getCode(), ErrorCode.IS_0201001.getDesc());
            return DubboResult.failResult((String)("bizId or batchSize is less than 0 , bizId :" + bizID + " batchSize:" + bacthSize));
        }
        bizID = StringUtils.isBlank((CharSequence)bizID) ? DEFAULT_BIZNO : bizID;
        long startIndex = 0L;
        try {
            startIndex = this.idMakerService.getBatchNextIdMysql(bizID, bacthSize);
        }
        catch (Exception e) {
            LOGGER.error("getBatchNextID error ", (Throwable)e);
            DB_LOGGER.error(ErrorCode.IS_0202001.getCode(), e.getMessage());
            return DubboResult.failResult((String)e.getMessage());
        }
        return DubboResult.successResult((Object)startIndex);
    }

    public DubboResult<Long> getBatchNextIDMysql(String bizID, long bacthSize) {
        if (bacthSize <= 0L) {
            DB_LOGGER.error(ErrorCode.IS_0201001.getCode(), ErrorCode.IS_0201001.getDesc());
            return DubboResult.failResult((String)("bizId or batchSize is less than 0 , bizId :" + bizID + " batchSize:" + bacthSize));
        }
        bizID = StringUtils.isBlank((CharSequence)bizID) ? DEFAULT_BIZNO : bizID;
        long startIndex = 0L;
        try {
            startIndex = this.idMakerService.getBatchNextIdMysql(bizID, bacthSize);
        }
        catch (Exception e) {
            LOGGER.error("getBatchNextIDMysql error ", (Throwable)e);
            DB_LOGGER.error(ErrorCode.IS_0202001.getCode(), e.getMessage());
            return DubboResult.failResult((String)e.getMessage());
        }
        return DubboResult.successResult((Object)startIndex);
    }
}

