/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.id.idmaker.service.biz.remoteservice.impl;

import cn.com.duiba.id.idmaker.service.biz.service.impl.IDMakerServiceImpl;
import cn.com.duiba.id.idmaker.service.biz.support.BizCodeChecker;
import cn.com.duiba.id.idmaker.service.biz.support.ErrorCode;
import cn.com.duiba.idmaker.service.api.remoteservice.RemoteIDMakerService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.log.DBLogger;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RemoteIDMakerServiceImpl
implements RemoteIDMakerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteIDMakerServiceImpl.class);
    private static final DBLogger DB_LOGGER = DBLogger.builder().aClass(RemoteIDMakerServiceImpl.class).build();
    private static final int MAX_BATCH_SIZE = 4000;
    @Resource
    private IDMakerServiceImpl idMakerServiceImpl;
    @Resource
    private BizCodeChecker bizCodeChecker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DubboResult<Long> getNextID(int bizID) {
        long nextId;
        if (bizID <= 0 || !this.bizCodeChecker.isAllow(bizID)) {
            DB_LOGGER.error(ErrorCode.IS_0101001.getCode(), ErrorCode.IS_0101001.getDesc());
            return DubboResult.failResult((String)("bizID is invalid  :" + bizID));
        }
        try {
            DBTimeProfile.enter((String)"getNextID");
            nextId = this.idMakerServiceImpl.getNextId(bizID);
        }
        catch (Exception e) {
            DB_LOGGER.error(ErrorCode.IS_0102001.getCode(), e.getMessage());
            LOGGER.error("get next ID error ,biz ID {}", (Object)new Object[]{String.valueOf(bizID)}, (Object)e);
            DubboResult dubboResult = DubboResult.failResult((String)("getBatchNextID failed :" + e.getMessage()));
            return dubboResult;
        }
        finally {
            DBTimeProfile.release();
        }
        return DubboResult.successResult((Object)nextId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DubboResult<List<Long>> getBatchNextID(int bizID, int bacthSize) {
        if (bizID <= 0 || !this.bizCodeChecker.isAllow(bizID) || bacthSize > 4000 || bacthSize <= 0) {
            DB_LOGGER.error(ErrorCode.IS_0101001.getCode(), ErrorCode.IS_0101001.getDesc());
            return DubboResult.failResult((String)("bizID is invalid  :" + bizID + "and max bacth size allow  :" + 4000));
        }
        ArrayList<Object> ids = null;
        try {
            DBTimeProfile.enter((String)"getBatchNextID");
            ids = new ArrayList<Object>(bacthSize);
            for (int i = 0; i < bacthSize; ++i) {
                DubboResult<Long> tempDubboResult = this.getNextID(bizID);
                if (!tempDubboResult.isSuccess()) {
                    DubboResult dubboResult = DubboResult.failResult((String)("get batch error : " + tempDubboResult.getMsg()));
                    return dubboResult;
                }
                ids.add(tempDubboResult.getResult());
            }
        }
        catch (Exception e) {
            DB_LOGGER.error(ErrorCode.IS_0102001.getCode(), e.getMessage());
            LOGGER.error("get next ID batch  error ,biz ID {} batch Size {} ", new Object[]{String.valueOf(bizID), String.valueOf(bacthSize)});
            DubboResult dubboResult = DubboResult.failResult((String)e.getMessage());
            return dubboResult;
        }
        finally {
            DBTimeProfile.release();
        }
        return DubboResult.successResult(ids);
    }
}

