/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.id.idmaker.service.biz.remoteservice.impl;

import cn.com.duiba.id.idmaker.service.biz.service.IdempotentService;
import cn.com.duiba.idmaker.service.api.enums.IdempotentTypeEnums;
import cn.com.duiba.idmaker.service.api.remoteservice.RemoteIdempotentService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class RemoteIdempotentServiceImpl
implements RemoteIdempotentService {
    @Resource
    private IdempotentService idempotentService;
    private int maxTtl = 7776000;

    public DubboResult<Boolean> createIdempotent(IdempotentTypeEnums bizType, String bizId, int ttl) {
        if (bizType == null || StringUtils.isEmpty((String)bizId)) {
            return DubboResult.failResult((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (bizId.length() > 255) {
            return DubboResult.failResult((String)"bizId\u957f\u5ea6\u8d85\u8fc7255");
        }
        if (ttl > this.maxTtl) {
            return DubboResult.failResult((String)"\u6700\u5927\u5e42\u7b49\u65f6\u95f4\u4e0d\u80fd\u8d85\u8fc73\u4e2a\u6708");
        }
        String key = this.idempotentService.getIdempotentKey(bizType, bizId);
        boolean check = this.idempotentService.createIdempotent(key, ttl);
        if (!check) {
            return DubboResult.failResult((String)("bizType:" + bizType.getDesc() + " bizId:" + bizId + " exist"));
        }
        return DubboResult.successResult((Object)check);
    }

    public DubboResult<Boolean> checkIdempotent(IdempotentTypeEnums bizType, String bizId) {
        String key = this.idempotentService.getIdempotentKey(bizType, bizId);
        boolean ret = this.idempotentService.checkIdempotent(key);
        if (ret) {
            return DubboResult.successResult((Object)ret);
        }
        return DubboResult.failResult((String)"\u5df2\u5904\u7406");
    }
}

