/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.id.idmaker.service.biz.service.impl;

import cn.com.duiba.id.idmaker.service.biz.IDWorker;
import cn.com.duiba.id.idmaker.service.biz.dao.SequenceDao;
import cn.com.duiba.id.idmaker.service.biz.service.IDMakerService;
import cn.com.duiba.id.idmaker.service.biz.support.InitOperation;
import cn.com.duiba.id.idmaker.service.biz.support.NetHelper;
import cn.com.duiba.id.idmaker.service.biz.support.RedisKeyFactory;
import cn.com.duiba.wolf.redis.RedisClient;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IDMakerServiceImpl
implements IDMakerService {
    @Resource
    private InitOperation initOperation;
    @Autowired
    private SequenceDao sequenceDao;
    @Resource
    private RedisClient redisClient;
    private static final int MAX_TIME_LOCK = 3;
    private Cache<Integer, IDWorker> bizIDCache = CacheBuilder.newBuilder().expireAfterAccess(12L, TimeUnit.HOURS).concurrencyLevel(Runtime.getRuntime().availableProcessors() + 1).build();

    @Override
    public long getNextId(int bizId) throws ExecutionException {
        IDWorker idWorker = this.getIdWorker(bizId);
        return idWorker.nextId();
    }

    private IDWorker getIdWorker(final Integer bizID) throws ExecutionException {
        return (IDWorker)this.bizIDCache.get((Object)bizID, (Callable)new Callable<IDWorker>(){

            @Override
            public IDWorker call() throws Exception {
                return new IDWorker(IDMakerServiceImpl.this.initOperation.getMachineId(), bizID.intValue());
            }
        });
    }

    @Override
    public long getCacheSize() {
        return this.bizIDCache.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getBatchNextId(String bizId, long bacthSize) {
        for (int i = 0; i < 10; ++i) {
            String lockKey = RedisKeyFactory.bizIdKeyLock(bizId);
            String lock = this.redisClient.set(lockKey, NetHelper.getLocalHostIP(), "nx", "ex", 3L);
            long startIndex = 0L;
            if (StringUtils.isNotBlank((CharSequence)lock)) {
                try {
                    String key = RedisKeyFactory.bizIdKey(bizId);
                    String s = this.redisClient.get(key);
                    startIndex = NumberUtils.isNumber((String)s) ? Long.valueOf(s) : 0L;
                    this.redisClient.incrBy(key, bacthSize);
                    long l = startIndex;
                    return l;
                }
                finally {
                    this.redisClient.del(lockKey);
                }
            }
            try {
                TimeUnit.MILLISECONDS.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        throw new IllegalStateException("get index error ");
    }

    @Override
    public long cleanCache() {
        long cacheSize = this.bizIDCache.size();
        this.bizIDCache.invalidateAll();
        return cacheSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getBatchNextIdMysql(String bizID, long bacthSize) throws Exception {
        for (int i = 0; i < 10; ++i) {
            String lockkey = RedisKeyFactory.bizIdKeyLock(bizID + "Mysql");
            String islock = this.redisClient.set(lockkey, NetHelper.getLocalHostIP(), "nx", "ex", 3L);
            if (StringUtils.isNotBlank((CharSequence)islock)) {
                try {
                    String key = RedisKeyFactory.bizIdKey(bizID);
                    Long mysqlId = this.sequenceDao.select(key);
                    if (mysqlId == null) {
                        mysqlId = 100000000L;
                        bacthSize = mysqlId + bacthSize;
                        this.sequenceDao.insert(key, bacthSize);
                    } else {
                        this.sequenceDao.incrBy(key, bacthSize);
                    }
                    long l = mysqlId;
                    return l;
                }
                finally {
                    this.redisClient.del(lockkey);
                }
            }
            Thread.sleep(100L);
        }
        throw new IllegalStateException("getBatchNextIdMysql error ");
    }
}

