/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.id.idmaker.service.biz.service.impl;

import cn.com.duiba.id.idmaker.service.biz.service.IdempotentService;
import cn.com.duiba.idmaker.service.api.enums.IdempotentTypeEnums;
import cn.com.duiba.wolf.redis.RedisClient;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class IdempotentServiceImpl
implements IdempotentService {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdempotentServiceImpl.class);
    @Resource
    private RedisClient redisClient;

    @Override
    public boolean createIdempotent(String key, int ttl) {
        try {
            String set = this.redisClient.set(key, String.valueOf(System.currentTimeMillis()), "nx", "ex", (long)ttl);
            if (StringUtils.isNotBlank((CharSequence)set)) {
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.error("createIdempotent:", (Throwable)e);
        }
        return false;
    }

    @Override
    public boolean checkIdempotent(String key) {
        try {
            String v = this.redisClient.get(key);
            if (v == null) {
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.error("checkIdempotent:", (Throwable)e);
        }
        return false;
    }

    @Override
    public String getIdempotentKey(IdempotentTypeEnums bizType, String bizId) {
        String key = "idempotent-" + bizType.getType() + "-" + bizId;
        return key;
    }
}

