/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.id.idmaker.service.biz.support.zk;

import cn.com.duiba.id.idmaker.service.biz.support.zk.ZKClientFactory;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ZKFacade {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZKFacade.class);
    @Value(value="${idmaker.zk.url}")
    private String zkURL;
    private CuratorFramework curatorFramework;
    public static final String PARENT_PATH = "/idmaker/ids";

    @PostConstruct
    public void init() {
        this.curatorFramework = ZKClientFactory.createSimple(this.zkURL);
        this.curatorFramework.start();
        try {
            Stat stat = (Stat)this.curatorFramework.checkExists().forPath(PARENT_PATH);
            if (stat == null) {
                this.curatorFramework.create().creatingParentContainersIfNeeded().forPath(PARENT_PATH);
            }
        }
        catch (Exception e) {
            LOGGER.error("init zookeeper path /idmaker/ids error ", (Throwable)e);
            System.exit(-1);
        }
    }

    public String getZkURL() {
        return this.zkURL;
    }

    public void setZkURL(String zkURL) {
        this.zkURL = zkURL;
    }

    public List<String> listNodes() throws Exception {
        return (List)this.curatorFramework.getChildren().forPath(PARENT_PATH);
    }

    public static void main(String[] args) throws Exception {
        ZKFacade zkFacade = new ZKFacade();
        zkFacade.setZkURL("192.168.1.115:2181");
        zkFacade.init();
        zkFacade.listNodes();
        zkFacade.try2Create("2");
    }

    public boolean try2Create(String id) {
        String childPath = "/idmaker/ids/" + id;
        String s = null;
        try {
            Stat stat = (Stat)this.curatorFramework.checkExists().forPath(childPath);
            if (stat != null) {
                return false;
            }
            s = (String)((ACLBackgroundPathAndBytesable)this.curatorFramework.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(childPath);
        }
        catch (Exception e) {
            return false;
        }
        return StringUtils.isNotBlank((CharSequence)s);
    }
}

