package cn.com.duiba.intersection.serivce.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.intersection.serivce.api.remoteservice.dto.GeneralRelationDto;
import cn.com.duiba.intersection.serivce.api.remoteservice.enums.GeneralRelationTypeEnum;

import java.util.List;

/**
 * Created by xiaoxuda on 2017/12/6.
 */
@AdvancedFeignClient
public interface RemoteGeneralRelationService {
    /**
     * 增加关系对
     * @param dto
     * @return 关系对ID
     */
    long insert(GeneralRelationDto dto);

    /**
     * 删除所有relationType分类下与partyAid有关的关系数据
     * @param relationType
     * @param partyAid
     * @return
     */
    int deleteByTypeAndPartyAid(GeneralRelationTypeEnum relationType, Long partyAid);

    /**
     *
     * @param relationType
     * @param partyAid
     * @param partyBids
     * @return
     */
    int batchDeleteByTypeAndPartyAidAndPartyBids(GeneralRelationTypeEnum relationType, Long partyAid, List<Long> partyBids);

    /**
     *
     * @param relationType
     * @param partyAid 可null
     * @param partyBid 可null
     * @return
     */
    List<GeneralRelationDto> findWithUniqueKey(GeneralRelationTypeEnum relationType, Long partyAid, Long partyBid);
}
