package cn.com.duiba.intersection.serivce.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.intersection.serivce.api.remoteservice.dto.IpLibraryDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by xiaoxuda on 2017/4/10.
 */
@AdvancedFeignClient
public interface RemoteIpLibraryService {
    /**
     * 插入数据,返回数据ID
     * @param dto
     * @return
     */
    DubboResult<Long> insert(IpLibraryDto dto);

    /**
     * 根据地区编码更新ip信息,返回更新的数据条数
     * @param dto
     * @return
     */
    DubboResult<Integer> updateByCode(IpLibraryDto dto);

    /**
     * 通过ip查询对应地区信息
     * @param ip
     * @return
     */
    DubboResult<IpLibraryDto> findByIp(String ip);

    /**
     * 通过地区编码查询IP信息
     * @param code
     * @return
     */
    DubboResult<IpLibraryDto> findByCode(Long code);
}
