package cn.com.duiba.intersection.serivce.api.remoteservice.dto;

import java.io.Serializable;

/**
 * Created by xiaoxuda on 2017/4/10.
 */
public class IpLibraryDto implements Serializable{
    private static final long serialVersionUID = -3289654383667474550L;

    private Long id;
    private Long startIpNum;
    private Long endIpNum;
    private String country;
    private String province;
    private String city;
    private String district;
    private String isp;
    private Long code;

    /**
     * 工具方法，把字符串ip转换成数字，方便搜索
     * @param strip
     * @return
     */
    public static Long convertIpLong(String strip) throws Exception{
        try {
            long[]ip=new long[4];
            int position1=strip.indexOf(".");
            int position2=strip.indexOf(".",position1+1);
            int position3=strip.indexOf(".",position2+1);
            ip[0]=Long.parseLong(strip.substring(0,position1));
            ip[1]=Long.parseLong(strip.substring(position1+1,position2));
            ip[2]=Long.parseLong(strip.substring(position2+1,position3));
            ip[3]=Long.parseLong(strip.substring(position3+1));
            return(ip[0]<<24)+(ip[1]<<16)+(ip[2]<<8)+ip[3];//ip1*256*256*256+ip2*256*256+ip3*256+ip4
        } catch (Exception e) {
            throw new Exception("IpLibraryDto.convertIpLong失败",e);
        }
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getStartIpNum() {
        return startIpNum;
    }

    public void setStartIpNum(Long startIpNum) {
        this.startIpNum = startIpNum;
    }

    public Long getEndIpNum() {
        return endIpNum;
    }

    public void setEndIpNum(Long endIpNum) {
        this.endIpNum = endIpNum;
    }

    public String getCountry() {
        return country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getDistrict() {
        return district;
    }

    public void setDistrict(String district) {
        this.district = district;
    }

    public String getIsp() {
        return isp;
    }

    public void setIsp(String isp) {
        this.isp = isp;
    }

    public Long getCode() {
        return code;
    }

    public void setCode(Long code) {
        this.code = code;
    }
}
