/**
 * Project Name:goods-center-api
 * File Name:Page.java
 * Package Name:cn.com.duiba.goods.center.api.remoteservice.tool
 * Date:2016年5月23日下午1:49:13
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.intersection.serivce.api.remoteservice.tools;

import java.io.Serializable;
import java.util.List;

/**
 * ClassName:Page <br/>
 * Function: 分页返回类 <br/>
 * Date:     2016年5月23日 下午1:49:13 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public class Page<T extends Serializable> implements Serializable {

    /**
     * @since JDK 1.6
     */
    private static final long serialVersionUID = 3697654457046529329L;

    private int current;
    
    private int pageSize=20;
    
    private int totalPages;
    
    private int totalCount;
    
    private List<T> list;
    
    public Page(int pageSize, int current){
        this.pageSize=pageSize;
        this.current=current;
    }

    public Page() {
    }

    public int getCurrent() {
        return current;
    }


    
    public void setCurrent(int current) {
        this.current = current;
    }


    
    public int getPageSize() {
        return pageSize;
    }


    
    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }


    
    public int getTotalPages() {
        return totalPages;
    }


    
    public void setTotalPages(int totalPages) {
        this.totalPages = totalPages;
    }



    
    public List<T> getList() {
        return list;
    }



    
    public void setList(List<T> list) {
        this.list = list;
    }



    
    public int getTotalCount() {
        return totalCount;
    }



    
    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }
}

