/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.disconf.client.addons.properties;

import com.baidu.disconf.client.addons.properties.DefaultPropertyPlaceholderConfigurer;
import com.baidu.disconf.client.addons.properties.IReconfigurationAware;
import com.baidu.disconf.client.addons.properties.IReloadablePropertiesListener;
import com.baidu.disconf.client.addons.properties.PropertiesReloadedEvent;
import com.baidu.disconf.client.addons.properties.ReloadableProperties;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionVisitor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.ObjectUtils;

public class ReloadingPropertyPlaceholderConfigurer
extends DefaultPropertyPlaceholderConfigurer
implements InitializingBean,
DisposableBean,
IReloadablePropertiesListener,
ApplicationContextAware {
    protected static final Logger logger = LoggerFactory.getLogger(ReloadingPropertyPlaceholderConfigurer.class);
    private String placeholderPrefix = "${";
    private String placeholderSuffix = "}";
    private String beanName;
    private BeanFactory beanFactory;
    private Properties[] propertiesArray;
    private Properties lastMergedProperties;
    private Map<DynamicProperty, DynamicProperty> dynamicProperties = new HashMap<DynamicProperty, DynamicProperty>();
    private Map<String, List<DynamicProperty>> placeholderToDynamics = new HashMap<String, List<DynamicProperty>>();
    private String currentBeanName;
    private String currentPropertyName;
    private ApplicationContext applicationContext;

    protected String parseStringValue(String strVal, Properties props, Set visitedPlaceholders) throws BeanDefinitionStoreException {
        DynamicProperty dynamic = null;
        StringBuffer buf = new StringBuffer(strVal);
        int startIndex = strVal.indexOf(this.placeholderPrefix);
        while (startIndex != -1) {
            int endIndex = buf.toString().indexOf(this.placeholderSuffix, startIndex + this.placeholderPrefix.length());
            if (endIndex != -1) {
                if (this.currentBeanName != null && this.currentPropertyName != null) {
                    String placeholder = buf.substring(startIndex + this.placeholderPrefix.length(), endIndex);
                    placeholder = this.getPlaceholder(placeholder);
                    if (dynamic == null) {
                        dynamic = this.getDynamic(this.currentBeanName, this.currentPropertyName, strVal);
                    }
                    this.addDependency(dynamic, placeholder);
                } else {
                    logger.warn("dynamic property outside bean property value - ignored: " + strVal);
                }
                startIndex = endIndex - this.placeholderPrefix.length() + this.placeholderPrefix.length() + this.placeholderSuffix.length();
                startIndex = strVal.indexOf(this.placeholderPrefix, startIndex);
                continue;
            }
            startIndex = -1;
        }
        return super.parseStringValue(buf.toString(), props, visitedPlaceholders);
    }

    private DynamicProperty getDynamic(String currentBeanName, String currentPropertyName, String orgStrVal) {
        DynamicProperty dynamic = new DynamicProperty(currentBeanName, currentPropertyName, orgStrVal);
        DynamicProperty found = this.dynamicProperties.get(dynamic);
        if (found != null) {
            return found;
        }
        this.dynamicProperties.put(dynamic, dynamic);
        return dynamic;
    }

    protected Properties mergeProperties() throws IOException {
        Properties properties;
        this.lastMergedProperties = properties = super.mergeProperties();
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertiesReloaded(PropertiesReloadedEvent event) {
        Properties oldProperties = this.lastMergedProperties;
        try {
            Object bean;
            Properties newProperties = this.mergeProperties();
            Set<String> placeholders = this.placeholderToDynamics.keySet();
            HashSet<DynamicProperty> allDynamics = new HashSet<DynamicProperty>();
            for (String placeholder : placeholders) {
                String newValue = newProperties.getProperty(placeholder);
                String oldValue = oldProperties.getProperty(placeholder);
                if ((newValue == null || newValue.equals(oldValue)) && (newValue != null || oldValue == null)) continue;
                if (logger.isInfoEnabled()) {
                    logger.info("Property changed detected: " + placeholder + (newValue != null ? "=" + newValue : " removed"));
                }
                List<DynamicProperty> affectedDynamics = this.placeholderToDynamics.get(placeholder);
                allDynamics.addAll(affectedDynamics);
            }
            HashMap<String, ArrayList<DynamicProperty>> dynamicsByBeanName = new HashMap<String, ArrayList<DynamicProperty>>();
            HashMap<String, Object> beanByBeanName = new HashMap<String, Object>();
            for (DynamicProperty dynamic : allDynamics) {
                String beanName = dynamic.getBeanName();
                ArrayList<DynamicProperty> l = (ArrayList<DynamicProperty>)dynamicsByBeanName.get(beanName);
                if (l == null) {
                    l = new ArrayList<DynamicProperty>();
                    dynamicsByBeanName.put(beanName, l);
                    Object bean2 = null;
                    try {
                        bean2 = this.applicationContext.getBean(beanName);
                        beanByBeanName.put(beanName, bean2);
                    }
                    catch (BeansException e) {
                        logger.error("Error obtaining bean " + beanName, (Throwable)e);
                    }
                    try {
                        if (bean2 instanceof IReconfigurationAware) {
                            ((IReconfigurationAware)bean2).beforeReconfiguration();
                        }
                    }
                    catch (Exception e) {
                        logger.error("Error calling beforeReconfiguration on " + beanName, (Throwable)e);
                    }
                }
                l.add(dynamic);
            }
            Set beanNames = dynamicsByBeanName.keySet();
            for (String beanName : beanNames) {
                bean = beanByBeanName.get(beanName);
                if (bean == null) continue;
                BeanWrapperImpl beanWrapper = new BeanWrapperImpl(bean);
                List dynamics = (List)dynamicsByBeanName.get(beanName);
                for (DynamicProperty dynamic : dynamics) {
                    String newValue;
                    String propertyName = dynamic.getPropertyName();
                    String unparsedValue = dynamic.getUnparsedValue();
                    this.removeDynamic(dynamic);
                    this.currentBeanName = beanName;
                    this.currentPropertyName = propertyName;
                    try {
                        newValue = this.parseStringValue(unparsedValue, newProperties, new HashSet());
                    }
                    finally {
                        this.currentBeanName = null;
                        this.currentPropertyName = null;
                    }
                    if (logger.isInfoEnabled()) {
                        logger.info("Updating property " + beanName + "." + propertyName + " to " + newValue);
                    }
                    try {
                        beanWrapper.setPropertyValue(propertyName, (Object)newValue);
                    }
                    catch (BeansException e) {
                        logger.error("Error setting property " + beanName + "." + propertyName + " to " + newValue, (Throwable)e);
                    }
                }
            }
            for (String beanName : beanNames) {
                bean = beanByBeanName.get(beanName);
                try {
                    if (!(bean instanceof IReconfigurationAware)) continue;
                    ((IReconfigurationAware)bean).afterReconfiguration();
                }
                catch (Exception e) {
                    logger.error("Error calling afterReconfiguration on " + beanName, (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            logger.error("Error trying to reload net.unicon.iamlabs.spring.properties.example.net.unicon.iamlabs.spring.properties: " + e.getMessage(), (Throwable)e);
        }
    }

    private void addDependency(DynamicProperty dynamic, String placeholder) {
        List<DynamicProperty> l = this.placeholderToDynamics.get(placeholder);
        if (l == null) {
            l = new ArrayList<DynamicProperty>();
            this.placeholderToDynamics.put(placeholder, l);
        }
        if (!l.contains(dynamic)) {
            l.add(dynamic);
        }
        dynamic.addPlaceholder(placeholder);
    }

    private void removeDynamic(DynamicProperty dynamic) {
        List<String> placeholders = dynamic.placeholders;
        for (String placeholder : placeholders) {
            List<DynamicProperty> l = this.placeholderToDynamics.get(placeholder);
            l.remove(dynamic);
        }
        dynamic.placeholders.clear();
        this.dynamicProperties.remove(dynamic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processProperties(ConfigurableListableBeanFactory beanFactoryToProcess, Properties props) throws BeansException {
        PlaceholderResolvingBeanDefinitionVisitor visitor = new PlaceholderResolvingBeanDefinitionVisitor(props);
        String[] beanNames = beanFactoryToProcess.getBeanDefinitionNames();
        for (int i = 0; i < beanNames.length; ++i) {
            if (beanNames[i].equals(this.beanName) && beanFactoryToProcess.equals(this.beanFactory)) continue;
            this.currentBeanName = beanNames[i];
            try {
                BeanDefinition bd = beanFactoryToProcess.getBeanDefinition(beanNames[i]);
                try {
                    visitor.visitBeanDefinition(bd);
                    continue;
                }
                catch (BeanDefinitionStoreException ex) {
                    throw new BeanDefinitionStoreException(bd.getResourceDescription(), beanNames[i], ex.getMessage());
                }
            }
            finally {
                this.currentBeanName = null;
            }
        }
    }

    public void afterPropertiesSet() {
        for (Properties properties : this.propertiesArray) {
            if (!(properties instanceof ReloadableProperties)) continue;
            logger.debug("add property listener: " + properties.toString());
            ((ReloadableProperties)((Object)properties)).addReloadablePropertiesListener(this);
        }
    }

    public void destroy() throws Exception {
        for (Properties properties : this.propertiesArray) {
            if (!(properties instanceof ReloadableProperties)) continue;
            logger.debug("remove property listener: " + properties.toString());
            ((ReloadableProperties)((Object)properties)).removeReloadablePropertiesListener(this);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setProperties(Properties properties) {
        this.setPropertiesArray(new Properties[]{properties});
    }

    public void setPropertiesArray(Properties[] propertiesArray) {
        this.propertiesArray = propertiesArray;
        super.setPropertiesArray(propertiesArray);
    }

    public void setPlaceholderPrefix(String placeholderPrefix) {
        this.placeholderPrefix = placeholderPrefix;
        super.setPlaceholderPrefix(placeholderPrefix);
    }

    public void setPlaceholderSuffix(String placeholderSuffix) {
        this.placeholderSuffix = placeholderSuffix;
        super.setPlaceholderSuffix(this.placeholderPrefix);
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
        super.setBeanName(beanName);
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        super.setBeanFactory(beanFactory);
    }

    private class PlaceholderResolvingBeanDefinitionVisitor
    extends BeanDefinitionVisitor {
        private final Properties props;

        public PlaceholderResolvingBeanDefinitionVisitor(Properties props) {
            this.props = props;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void visitPropertyValues(MutablePropertyValues pvs) {
            PropertyValue[] pvArray;
            for (PropertyValue pv : pvArray = pvs.getPropertyValues()) {
                ReloadingPropertyPlaceholderConfigurer.this.currentPropertyName = pv.getName();
                try {
                    Object newVal = this.resolveValue(pv.getValue());
                    if (ObjectUtils.nullSafeEquals((Object)newVal, (Object)pv.getValue())) continue;
                    pvs.addPropertyValue(pv.getName(), newVal);
                }
                finally {
                    ReloadingPropertyPlaceholderConfigurer.this.currentPropertyName = null;
                }
            }
        }

        protected String resolveStringValue(String strVal) throws BeansException {
            return ReloadingPropertyPlaceholderConfigurer.this.parseStringValue(strVal, this.props, new HashSet());
        }
    }

    static class DynamicProperty {
        final String beanName;
        final String propertyName;
        final String unparsedValue;
        List<String> placeholders = new ArrayList<String>();

        public DynamicProperty(String beanName, String propertyName, String unparsedValue) {
            this.beanName = beanName;
            this.propertyName = propertyName;
            this.unparsedValue = unparsedValue;
        }

        public void addPlaceholder(String placeholder) {
            this.placeholders.add(placeholder);
        }

        public String getUnparsedValue() {
            return this.unparsedValue;
        }

        public String getBeanName() {
            return this.beanName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DynamicProperty that = (DynamicProperty)o;
            if (this.beanName != null ? !this.beanName.equals(that.beanName) : that.beanName != null) {
                return false;
            }
            return !(this.propertyName != null ? !this.propertyName.equals(that.propertyName) : that.propertyName != null);
        }

        public int hashCode() {
            int result = this.beanName != null ? this.beanName.hashCode() : 0;
            result = 29 * result + (this.propertyName != null ? this.propertyName.hashCode() : 0);
            return result;
        }
    }
}

