/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.yanf4j.nio.impl;

import com.google.code.yanf4j.config.Configuration;
import com.google.code.yanf4j.core.EventType;
import com.google.code.yanf4j.core.Session;
import com.google.code.yanf4j.nio.impl.NioController;
import com.google.code.yanf4j.nio.impl.Reactor;
import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectorManager {
    private final Reactor[] reactorSet;
    private final AtomicInteger sets = new AtomicInteger(0);
    private final NioController controller;
    private final int dividend;
    private int reactorReadyCount;
    private volatile boolean started;
    public static final String REACTOR_ATTRIBUTE = System.currentTimeMillis() + "_Reactor_Attribute";
    private static final Logger log = LoggerFactory.getLogger(SelectorManager.class);

    public SelectorManager(int selectorPoolSize, NioController controller, Configuration conf) throws IOException {
        if (selectorPoolSize <= 0) {
            throw new IllegalArgumentException("selectorPoolSize<=0");
        }
        log.info("Creating " + selectorPoolSize + " reactors...");
        this.reactorSet = new Reactor[selectorPoolSize];
        this.controller = controller;
        for (int i = 0; i < selectorPoolSize; ++i) {
            this.reactorSet[i] = new Reactor(this, conf, i);
        }
        this.dividend = this.reactorSet.length - 1;
    }

    public int getSelectorCount() {
        return this.reactorSet == null ? 0 : this.reactorSet.length;
    }

    public synchronized void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        for (Reactor reactor : this.reactorSet) {
            reactor.start();
        }
    }

    Reactor getReactorFromSession(Session session) {
        Reactor oldReactor;
        Reactor reactor = (Reactor)session.getAttribute(REACTOR_ATTRIBUTE);
        if (reactor == null && (oldReactor = (Reactor)session.setAttributeIfAbsent(REACTOR_ATTRIBUTE, reactor = this.nextReactor())) != null) {
            reactor = oldReactor;
        }
        return reactor;
    }

    public Reactor getReactorByIndex(int index) {
        if (index < 0 || index > this.reactorSet.length - 1) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.reactorSet[index];
    }

    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        this.started = false;
        for (Reactor reactor : this.reactorSet) {
            reactor.interrupt();
        }
    }

    public final Reactor registerChannel(SelectableChannel channel, int ops, Object attachment) {
        this.awaitReady();
        int index = 0;
        index = ops == 16 || ops == 8 ? 0 : this.sets.incrementAndGet() % this.dividend + 1;
        Reactor reactor = this.reactorSet[index];
        reactor.registerChannel(channel, ops, attachment);
        return reactor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void awaitReady() {
        SelectorManager selectorManager = this;
        synchronized (selectorManager) {
            while (!this.started || this.reactorReadyCount != this.reactorSet.length) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    public final Reactor nextReactor() {
        if (this.dividend > 0) {
            return this.reactorSet[this.sets.incrementAndGet() % this.dividend + 1];
        }
        return this.reactorSet[0];
    }

    public final void registerSession(Session session, EventType event) {
        Reactor oldReactor;
        if (session.isClosed() && event != EventType.UNREGISTER) {
            return;
        }
        Reactor reactor = (Reactor)session.getAttribute(REACTOR_ATTRIBUTE);
        if (reactor == null && (oldReactor = (Reactor)session.setAttributeIfAbsent(REACTOR_ATTRIBUTE, reactor = this.nextReactor())) != null) {
            reactor = oldReactor;
        }
        reactor.registerSession(session, event);
    }

    public NioController getController() {
        return this.controller;
    }

    synchronized void notifyReady() {
        ++this.reactorReadyCount;
        if (this.reactorReadyCount == this.reactorSet.length) {
            this.controller.notifyReady();
            this.notifyAll();
        }
    }

    public final boolean isStarted() {
        return this.started;
    }
}

