/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.internal.execution;

import com.dangdang.ddframe.job.api.JobConfiguration;
import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import com.dangdang.ddframe.job.internal.config.ConfigurationService;
import com.dangdang.ddframe.job.internal.execution.ExecutionNode;
import com.dangdang.ddframe.job.internal.offset.OffsetService;
import com.dangdang.ddframe.job.internal.storage.JobNodeStorage;
import com.dangdang.ddframe.reg.base.CoordinatorRegistryCenter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ExecutionContextService {
    private final JobConfiguration jobConfiguration;
    private final JobNodeStorage jobNodeStorage;
    private final ConfigurationService configService;
    private final OffsetService offsetService;

    public ExecutionContextService(CoordinatorRegistryCenter coordinatorRegistryCenter, JobConfiguration jobConfiguration) {
        this.jobConfiguration = jobConfiguration;
        this.jobNodeStorage = new JobNodeStorage(coordinatorRegistryCenter, jobConfiguration);
        this.configService = new ConfigurationService(coordinatorRegistryCenter, jobConfiguration);
        this.offsetService = new OffsetService(coordinatorRegistryCenter, jobConfiguration);
    }

    public JobExecutionMultipleShardingContext getJobExecutionShardingContext(List<Integer> shardingItems) {
        JobExecutionMultipleShardingContext result = new JobExecutionMultipleShardingContext();
        result.setJobName(this.jobConfiguration.getJobName());
        result.setShardingTotalCount(this.configService.getShardingTotalCount());
        result.setShardingItems(shardingItems);
        boolean isMonitorExecution = this.configService.isMonitorExecution();
        if (isMonitorExecution) {
            this.removeRunningItems(shardingItems);
        }
        result.setJobParameter(this.configService.getJobParameter());
        result.setMonitorExecution(isMonitorExecution);
        result.setFetchDataCount(this.configService.getFetchDataCount());
        if (result.getShardingItems().isEmpty()) {
            return result;
        }
        Map<Integer, String> shardingItemParameters = this.configService.getShardingItemParameters();
        for (int each : result.getShardingItems()) {
            if (!shardingItemParameters.containsKey(each)) continue;
            result.getShardingItemParameters().put(each, shardingItemParameters.get(each));
        }
        result.setOffsets(this.offsetService.getOffsets(result.getShardingItems()));
        return result;
    }

    private void removeRunningItems(List<Integer> items) {
        ArrayList<Integer> toBeRemovedItems = new ArrayList<Integer>(items.size());
        for (int each : items) {
            if (!this.isRunningItem(each)) continue;
            toBeRemovedItems.add(each);
        }
        items.removeAll(toBeRemovedItems);
    }

    private boolean isRunningItem(int item) {
        return this.jobNodeStorage.isJobNodeExisted(ExecutionNode.getRunningNode(item));
    }
}

