/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.internal.util;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SensitiveInfoUtils {
    public static List<String> filterSensitiveIps(List<String> result) {
        final HashMap fakeIpMap = new HashMap();
        String fakeIpSample = "ip";
        final AtomicInteger step = new AtomicInteger();
        Function<String, String> func = new Function<String, String>(){

            public String apply(String line) {
                String regex = "\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}";
                Pattern pattern = Pattern.compile("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}");
                Matcher matcher = pattern.matcher(line);
                String result = line;
                while (matcher.find()) {
                    String realIp = matcher.group();
                    String fakeIp = (String)fakeIpMap.get(realIp);
                    if (Strings.isNullOrEmpty((String)fakeIp)) {
                        fakeIp = "ip" + step.incrementAndGet();
                        fakeIpMap.put(realIp, fakeIp);
                    }
                    result = result.replace(realIp, fakeIp);
                }
                return result;
            }
        };
        return Lists.transform(result, (Function)func);
    }

    private SensitiveInfoUtils() {
    }
}

